/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.AbstractTuplePointerAccessor;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotLastFit;
import org.apache.hyracks.dataflow.std.buffermanager.IDeletableTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.IFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.sort.util.DeletableFrameTupleAppender;
import org.apache.hyracks.dataflow.std.sort.util.IAppendDeletableFrameTupleAccessor;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableDeletableTupleMemoryManager
implements IDeletableTupleBufferManager {
    private static final Logger LOG = LogManager.getLogger();
    private final int minFreeSpace;
    private final IFramePool pool;
    private final IFrameFreeSlotPolicy policy;
    private final IAppendDeletableFrameTupleAccessor accessor;
    private final ArrayList<ByteBuffer> frames;
    private final RecordDescriptor recordDescriptor;
    private int numTuples;
    private int statsReOrg;

    public VariableDeletableTupleMemoryManager(IFramePool framePool, RecordDescriptor recordDescriptor) {
        this.pool = framePool;
        int maxFrames = framePool.getMemoryBudgetBytes() / framePool.getMinFrameSize();
        this.policy = new FrameFreeSlotLastFit(maxFrames);
        this.accessor = new DeletableFrameTupleAppender(recordDescriptor);
        this.frames = new ArrayList();
        this.minFreeSpace = VariableDeletableTupleMemoryManager.calculateMinFreeSpace(recordDescriptor);
        this.recordDescriptor = recordDescriptor;
        this.numTuples = 0;
        this.statsReOrg = 0;
    }

    @Override
    public void reset() throws HyracksDataException {
        this.pool.reset();
        this.policy.reset();
        this.frames.clear();
        this.numTuples = 0;
    }

    @Override
    public int getNumTuples() {
        return this.numTuples;
    }

    @Override
    public boolean insertTuple(IFrameTupleAccessor fta, int idx, TuplePointer tuplePointer) throws HyracksDataException {
        int requiredFreeSpace = VariableDeletableTupleMemoryManager.calculatePhysicalSpace(fta, idx);
        int frameId = this.findAvailableFrame(requiredFreeSpace);
        if (frameId < 0) {
            if (this.canBeInsertedAfterCleanUpFragmentation(requiredFreeSpace)) {
                this.reOrganizeFrames();
                frameId = this.findAvailableFrame(requiredFreeSpace);
                ++this.statsReOrg;
            } else {
                return false;
            }
        }
        assert (frameId >= 0);
        this.accessor.reset(this.frames.get(frameId));
        assert (this.accessor.getContiguousFreeSpace() >= requiredFreeSpace);
        int tid = this.accessor.append(fta, idx);
        assert (tid >= 0);
        tuplePointer.reset(frameId, tid);
        if (this.accessor.getContiguousFreeSpace() > this.minFreeSpace) {
            this.policy.pushNewFrame(frameId, this.accessor.getContiguousFreeSpace());
        }
        ++this.numTuples;
        return true;
    }

    private void reOrganizeFrames() {
        this.policy.reset();
        for (int i = 0; i < this.frames.size(); ++i) {
            this.accessor.reset(this.frames.get(i));
            this.accessor.reOrganizeBuffer();
            this.policy.pushNewFrame(i, this.accessor.getContiguousFreeSpace());
        }
    }

    private boolean canBeInsertedAfterCleanUpFragmentation(int requiredFreeSpace) {
        for (int i = 0; i < this.frames.size(); ++i) {
            this.accessor.reset(this.frames.get(i));
            if (this.accessor.getTotalFreeSpace() < requiredFreeSpace) continue;
            return true;
        }
        return false;
    }

    private int findAvailableFrame(int requiredFreeSpace) throws HyracksDataException {
        int frameId = this.policy.popBestFit(requiredFreeSpace);
        if (frameId >= 0) {
            return frameId;
        }
        int frameSize = VariableDeletableTupleMemoryManager.calculateMinFrameSizeToPlaceTuple(requiredFreeSpace, this.pool.getMinFrameSize());
        ByteBuffer buffer = this.pool.allocateFrame(frameSize);
        if (buffer != null) {
            this.accessor.clear(buffer);
            this.frames.add(buffer);
            return this.frames.size() - 1;
        }
        return -1;
    }

    private static int calculateMinFrameSizeToPlaceTuple(int requiredFreeSpace, int minFrameSize) {
        return (1 + (requiredFreeSpace + 4 - 1) / minFrameSize) * minFrameSize;
    }

    private static int calculatePhysicalSpace(IFrameTupleAccessor fta, int idx) {
        return 4 + fta.getTupleLength(idx);
    }

    private static int calculateMinFreeSpace(RecordDescriptor recordDescriptor) {
        return recordDescriptor.getFieldCount() * 4 + 4;
    }

    @Override
    public void deleteTuple(TuplePointer tuplePointer) throws HyracksDataException {
        this.accessor.reset(this.frames.get(tuplePointer.getFrameIndex()));
        this.accessor.delete(tuplePointer.getTupleIndex());
        --this.numTuples;
    }

    @Override
    public void close() {
        this.pool.close();
        this.policy.reset();
        this.frames.clear();
        this.numTuples = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("VariableTupleMemoryManager has reorganized " + this.statsReOrg + " times");
        }
        this.statsReOrg = 0;
    }

    @Override
    public ITuplePointerAccessor createTuplePointerAccessor() {
        return new AbstractTuplePointerAccessor(){
            private final IAppendDeletableFrameTupleAccessor bufferAccessor;
            {
                this.bufferAccessor = new DeletableFrameTupleAppender(VariableDeletableTupleMemoryManager.this.recordDescriptor);
            }

            @Override
            IFrameTupleAccessor getInnerAccessor() {
                return this.bufferAccessor;
            }

            @Override
            void resetInnerAccessor(TuplePointer tuplePointer) {
                this.bufferAccessor.reset((ByteBuffer)VariableDeletableTupleMemoryManager.this.frames.get(tuplePointer.getFrameIndex()));
            }
        };
    }
}

