/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.OperatorDeepCopyVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;

public class OperatorManipulationUtil {
    public static void ntsToEts(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
            context.computeAndSetTypeEnvironmentForOperator(ets);
            opRef.setValue((Object)ets);
        } else {
            for (Mutable<ILogicalOperator> i : ((ILogicalOperator)opRef.getValue()).getInputs()) {
                OperatorManipulationUtil.ntsToEts(i, context);
            }
        }
    }

    public static ILogicalOperator eliminateSingleSubplanOverEts(SubplanOperator subplan) {
        if (subplan.getNestedPlans().size() > 1) {
            List<Mutable<ILogicalOperator>> subInpList = subplan.getInputs();
            subInpList.clear();
            subInpList.add((Mutable<ILogicalOperator>)new MutableObject((Object)new EmptyTupleSourceOperator()));
            return subplan;
        }
        ILogicalPlan plan = subplan.getNestedPlans().get(0);
        if (plan.getRoots().size() > 1) {
            List<Mutable<ILogicalOperator>> subInpList = subplan.getInputs();
            subInpList.clear();
            subInpList.add((Mutable<ILogicalOperator>)new MutableObject((Object)new EmptyTupleSourceOperator()));
            return subplan;
        }
        return (ILogicalOperator)plan.getRoots().get(0).getValue();
    }

    public static boolean setOperatorMode(AbstractLogicalOperator op) {
        AbstractLogicalOperator.ExecutionMode oldMode = op.getExecutionMode();
        block0 : switch (op.getOperatorTag()) {
            case DATASOURCESCAN: {
                AbstractLogicalOperator child;
                op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                AbstractLogicalOperator currentOp = op;
                while (currentOp.getInputs().size() == 1 && (child = (AbstractLogicalOperator)currentOp.getInputs().get(0).getValue()).getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
                    child.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                    currentOp = child;
                }
                break;
            }
            case NESTEDTUPLESOURCE: {
                NestedTupleSourceOperator nts = (NestedTupleSourceOperator)op;
                AbstractLogicalOperator prevOp = (AbstractLogicalOperator)((ILogicalOperator)nts.getDataSourceReference().getValue()).getInputs().get(0).getValue();
                if (prevOp.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) break;
                nts.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
                break;
            }
            default: {
                GroupByOperator gbyOp;
                AggregateOperator aggOp;
                LimitOperator opLim;
                boolean forceUnpartitioned = false;
                if (op.getOperatorTag() == LogicalOperatorTag.LIMIT && (opLim = (LimitOperator)op).isTopmostLimitOp()) {
                    opLim.setExecutionMode(AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
                    forceUnpartitioned = true;
                }
                if (op.getOperatorTag() == LogicalOperatorTag.AGGREGATE && (aggOp = (AggregateOperator)op).isGlobal()) {
                    op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
                    forceUnpartitioned = true;
                }
                if (op.getOperatorTag() == LogicalOperatorTag.GROUP && (gbyOp = (GroupByOperator)op).isGroupAll() && gbyOp.isGlobal()) {
                    op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
                    forceUnpartitioned = true;
                }
                for (Mutable<ILogicalOperator> i : op.getInputs()) {
                    boolean exit = false;
                    AbstractLogicalOperator inputOp = (AbstractLogicalOperator)i.getValue();
                    switch (inputOp.getExecutionMode()) {
                        case PARTITIONED: {
                            if (forceUnpartitioned) break;
                            op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                            exit = true;
                            break;
                        }
                        case LOCAL: {
                            op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
                        }
                    }
                    if (!exit) continue;
                    break block0;
                }
            }
        }
        return oldMode != op.getExecutionMode();
    }

    public static void substituteVarRec(AbstractLogicalOperator op, LogicalVariable v1, LogicalVariable v2, boolean goThroughNts, ITypingContext ctx) throws AlgebricksException {
        NestedTupleSourceOperator nts;
        VariableUtilities.substituteVariables(op, v1, v2, goThroughNts, ctx);
        for (Mutable<ILogicalOperator> opRef2 : op.getInputs()) {
            OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)opRef2.getValue(), v1, v2, goThroughNts, ctx);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE && goThroughNts && (nts = (NestedTupleSourceOperator)op).getDataSourceReference() != null) {
            AbstractLogicalOperator op2 = (AbstractLogicalOperator)((ILogicalOperator)nts.getDataSourceReference().getValue()).getInputs().get(0).getValue();
            OperatorManipulationUtil.substituteVarRec(op2, v1, v2, goThroughNts, ctx);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans aonp = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : aonp.getNestedPlans()) {
                for (Mutable<ILogicalOperator> ref : p.getRoots()) {
                    AbstractLogicalOperator aop = (AbstractLogicalOperator)ref.getValue();
                    OperatorManipulationUtil.substituteVarRec(aop, v1, v2, goThroughNts, ctx);
                }
            }
        }
    }

    public static ILogicalPlan deepCopy(ILogicalPlan plan, ILogicalOperator dataSource) throws AlgebricksException {
        List<Mutable<ILogicalOperator>> roots = plan.getRoots();
        List<Mutable<ILogicalOperator>> newRoots = OperatorManipulationUtil.clonePipeline(roots);
        ALogicalPlanImpl newPlan = new ALogicalPlanImpl(newRoots);
        OperatorManipulationUtil.setDataSource(newPlan, dataSource);
        return newPlan;
    }

    public static ILogicalPlan deepCopy(ILogicalPlan plan, IOptimizationContext ctx) throws AlgebricksException {
        List<Mutable<ILogicalOperator>> roots = plan.getRoots();
        List<Mutable<ILogicalOperator>> newRoots = OperatorManipulationUtil.clonePipeline(roots);
        OperatorManipulationUtil.cloneTypeEnvironments(ctx, roots, newRoots);
        return new ALogicalPlanImpl(newRoots);
    }

    public static Pair<ILogicalOperator, Map<LogicalVariable, LogicalVariable>> deepCopyWithNewVars(ILogicalOperator root, IOptimizationContext ctx) throws AlgebricksException {
        LogicalOperatorDeepCopyWithNewVariablesVisitor deepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor(ctx, ctx, true);
        ILogicalOperator newRoot = deepCopyVisitor.deepCopy(root);
        return Pair.of((Object)newRoot, deepCopyVisitor.getInputToOutputVariableMapping());
    }

    private static void setDataSource(ILogicalPlan plan, ILogicalOperator dataSource) {
        for (Mutable<ILogicalOperator> rootRef : plan.getRoots()) {
            OperatorManipulationUtil.setDataSource(rootRef, dataSource);
        }
    }

    private static void setDataSource(Mutable<ILogicalOperator> opRef, ILogicalOperator dataSource) {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            NestedTupleSourceOperator nts = (NestedTupleSourceOperator)op;
            nts.setDataSourceReference((Mutable<ILogicalOperator>)new MutableObject((Object)dataSource));
        }
        for (Mutable<ILogicalOperator> childRef : op.getInputs()) {
            OperatorManipulationUtil.setDataSource(childRef, dataSource);
        }
    }

    private static List<Mutable<ILogicalOperator>> clonePipeline(List<Mutable<ILogicalOperator>> roots) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> newRoots = new ArrayList<Mutable<ILogicalOperator>>();
        for (Mutable<ILogicalOperator> opRef : roots) {
            newRoots.add((Mutable<ILogicalOperator>)new MutableObject((Object)OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)opRef.getValue())));
        }
        return newRoots;
    }

    private static void cloneTypeEnvironments(IOptimizationContext ctx, List<Mutable<ILogicalOperator>> roots, List<Mutable<ILogicalOperator>> newRoots) {
        for (int i = 0; i < newRoots.size(); ++i) {
            Mutable<ILogicalOperator> opRef = newRoots.get(i);
            Mutable<ILogicalOperator> oldOpRef = roots.get(i);
            while (((ILogicalOperator)opRef.getValue()).getInputs().size() > 0) {
                ctx.setOutputTypeEnvironment((ILogicalOperator)opRef.getValue(), ctx.getOutputTypeEnvironment((ILogicalOperator)oldOpRef.getValue()));
                opRef = ((ILogicalOperator)opRef.getValue()).getInputs().get(0);
                oldOpRef = ((ILogicalOperator)oldOpRef.getValue()).getInputs().get(0);
            }
            ctx.setOutputTypeEnvironment((ILogicalOperator)opRef.getValue(), ctx.getOutputTypeEnvironment((ILogicalOperator)oldOpRef.getValue()));
        }
    }

    public static ILogicalOperator bottomUpCopyOperators(ILogicalOperator op) throws AlgebricksException {
        ILogicalOperator newOp = OperatorManipulationUtil.deepCopy(op);
        newOp.getInputs().clear();
        for (Mutable<ILogicalOperator> child : op.getInputs()) {
            newOp.getInputs().add((Mutable<ILogicalOperator>)new MutableObject((Object)OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)child.getValue())));
        }
        return newOp;
    }

    public static ILogicalOperator deepCopy(ILogicalOperator op) throws AlgebricksException {
        OperatorDeepCopyVisitor visitor = new OperatorDeepCopyVisitor();
        AbstractLogicalOperator copiedOperator = (AbstractLogicalOperator)op.accept(visitor, null);
        copiedOperator.setSourceLocation(op.getSourceLocation());
        copiedOperator.setExecutionMode(op.getExecutionMode());
        copiedOperator.getAnnotations().putAll(op.getAnnotations());
        copiedOperator.setSchema(op.getSchema());
        AbstractLogicalOperator sourceOp = (AbstractLogicalOperator)op;
        copiedOperator.setPhysicalOperator(sourceOp.getPhysicalOperator());
        return copiedOperator;
    }

    public static void computeTypeEnvironmentBottomUp(ILogicalOperator op, ITypingContext context) throws AlgebricksException {
        for (Mutable<ILogicalOperator> children : op.getInputs()) {
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)children.getValue(), context);
        }
        AbstractLogicalOperator abstractOp = (AbstractLogicalOperator)op;
        if (abstractOp.hasNestedPlans()) {
            for (ILogicalPlan p : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                for (Mutable<ILogicalOperator> rootRef : p.getRoots()) {
                    OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)rootRef.getValue(), context);
                }
            }
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
    }

    public static void computeTypeEnvironment(ILogicalPlan plan, ITypingContext context) throws AlgebricksException {
        for (Mutable<ILogicalOperator> rootRef : plan.getRoots()) {
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)rootRef.getValue(), context);
        }
    }

    public static boolean ancestorOfOperators(ILogicalOperator op, Set<LogicalOperatorTag> tags) {
        LogicalOperatorTag opTag = op.getOperatorTag();
        if (tags.contains((Object)opTag)) {
            return true;
        }
        for (Mutable<ILogicalOperator> children : op.getInputs()) {
            if (!OperatorManipulationUtil.ancestorOfOperators((ILogicalOperator)children.getValue(), tags)) continue;
            return true;
        }
        return false;
    }

    public static List<Mutable<ILogicalOperator>> findLeafDescendantsOrSelf(Mutable<ILogicalOperator> opRef) {
        Mutable currentOpRef;
        List<Mutable<ILogicalOperator>> result = Collections.emptyList();
        ArrayDeque<Mutable<ILogicalOperator>> queue = new ArrayDeque<Mutable<ILogicalOperator>>();
        queue.add(opRef);
        while ((currentOpRef = (Mutable)queue.pollLast()) != null) {
            List<Mutable<ILogicalOperator>> inputs = ((ILogicalOperator)currentOpRef.getValue()).getInputs();
            if (inputs.isEmpty()) {
                if (result.isEmpty()) {
                    result = new ArrayList<Mutable<ILogicalOperator>>();
                }
                result.add((Mutable<ILogicalOperator>)currentOpRef);
                continue;
            }
            queue.addAll(inputs);
        }
        return result;
    }

    public static int indexOf(List<Mutable<ILogicalOperator>> list, ILogicalOperator op) {
        int ln = list.size();
        for (int i = 0; i < ln; ++i) {
            if (list.get(i).getValue() != op) continue;
            return i;
        }
        return -1;
    }
}

