/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.AbstractGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;

public final class UnorderedPartitionedProperty
extends AbstractGroupingProperty
implements IPartitioningProperty {
    private INodeDomain domain;

    public UnorderedPartitionedProperty(Set<LogicalVariable> partitioningVariables, INodeDomain domain) {
        super(partitioningVariables);
        this.domain = domain;
    }

    @Override
    public IPartitioningProperty.PartitioningType getPartitioningType() {
        return IPartitioningProperty.PartitioningType.UNORDERED_PARTITIONED;
    }

    @Override
    public IPartitioningProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        Set<LogicalVariable> normalizedColumnSet = this.normalizeAndReduceGroupingColumns(this.columnSet, equivalenceClasses, fds);
        return new UnorderedPartitionedProperty(normalizedColumnSet, this.domain);
    }

    public String toString() {
        return this.getPartitioningType().toString() + this.columnSet;
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        columns.addAll(this.columnSet);
    }

    @Override
    public INodeDomain getNodeDomain() {
        return this.domain;
    }

    @Override
    public void setNodeDomain(INodeDomain domain) {
        this.domain = domain;
    }

    @Override
    public void substituteColumnVars(Map<LogicalVariable, LogicalVariable> varMap) {
        varMap.forEach((key, value) -> {
            if (this.columnSet.remove(key)) {
                this.columnSet.add(value);
            }
        });
    }

    @Override
    public IPartitioningProperty clonePartitioningProperty() {
        return new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet((Collection)this.columnSet), this.domain);
    }
}

