/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.prettyprint;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalExpressionPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public abstract class AbstractLogicalOperatorPrettyPrintVisitor
implements ILogicalOperatorVisitor<Void, Integer> {
    ILogicalExpressionVisitor<String, Integer> exprVisitor;
    AlgebricksAppendable buffer;

    public AbstractLogicalOperatorPrettyPrintVisitor() {
        this(new AlgebricksAppendable());
    }

    public AbstractLogicalOperatorPrettyPrintVisitor(Appendable app) {
        this(new AlgebricksAppendable(app), new LogicalExpressionPrettyPrintVisitor());
    }

    public AbstractLogicalOperatorPrettyPrintVisitor(AlgebricksAppendable buffer) {
        this(buffer, new LogicalExpressionPrettyPrintVisitor());
    }

    public AbstractLogicalOperatorPrettyPrintVisitor(AlgebricksAppendable buffer, ILogicalExpressionVisitor<String, Integer> exprVisitor) {
        this.reset(buffer);
        this.exprVisitor = exprVisitor;
    }

    public AlgebricksAppendable reset(AlgebricksAppendable buffer) {
        AlgebricksAppendable old = this.buffer;
        this.buffer = buffer;
        return old;
    }

    public AlgebricksAppendable get() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    CharSequence str(Object o) {
        return String.valueOf(o);
    }

    protected static void appendln(AlgebricksAppendable buf, String s) throws AlgebricksException {
        buf.append(s);
        buf.append("\n");
    }

    protected static void append(AlgebricksAppendable buf, String s) throws AlgebricksException {
        buf.append(s);
    }

    protected static void pad(AlgebricksAppendable buf, int indent) throws AlgebricksException {
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
    }

    protected AlgebricksAppendable addIndent(int level) throws AlgebricksException {
        for (int i = 0; i < level; ++i) {
            this.buffer.append(' ');
        }
        return this.buffer;
    }

    public void printPlan(ILogicalPlan plan, int indent) throws AlgebricksException {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            this.printOperator((AbstractLogicalOperator)root.getValue(), indent);
        }
    }

    public abstract void printOperator(AbstractLogicalOperator var1, int var2) throws AlgebricksException;

    public static void printPhysicalOperator(AbstractLogicalOperator op, int indent, AlgebricksAppendable out) throws AlgebricksException {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        AbstractLogicalOperatorPrettyPrintVisitor.pad(out, indent);
        AbstractLogicalOperatorPrettyPrintVisitor.appendln(out, "-- " + pOp.toString() + "  |" + (Object)((Object)op.getExecutionMode()) + "|");
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opNest = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : opNest.getNestedPlans()) {
                AbstractLogicalOperatorPrettyPrintVisitor.pad(out, indent + 8);
                AbstractLogicalOperatorPrettyPrintVisitor.appendln(out, "{");
                AbstractLogicalOperatorPrettyPrintVisitor.printPhysicalOps(p, out, indent + 10);
                AbstractLogicalOperatorPrettyPrintVisitor.pad(out, indent + 8);
                AbstractLogicalOperatorPrettyPrintVisitor.appendln(out, "}");
            }
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            AbstractLogicalOperatorPrettyPrintVisitor.printPhysicalOperator((AbstractLogicalOperator)i.getValue(), indent + 2, out);
        }
    }

    public static void printPhysicalOps(ILogicalPlan plan, AlgebricksAppendable out, int indent) throws AlgebricksException {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            AbstractLogicalOperatorPrettyPrintVisitor.printPhysicalOperator((AbstractLogicalOperator)root.getValue(), indent, out);
        }
    }
}

