/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.algebricks.core.algebra.operators.physical.JoinMultiComparator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;

class JoinMultiComparatorFactory
implements ITuplePairComparatorFactory {
    private static final long serialVersionUID = 1L;
    private final IBinaryComparatorFactory[] binaryComparatorFactories;
    private final int[] keysLeft;
    private final int[] keysRight;

    public JoinMultiComparatorFactory(IBinaryComparatorFactory[] binaryComparatorFactory, int[] keysLeft, int[] keysRight) {
        this.binaryComparatorFactories = binaryComparatorFactory;
        this.keysLeft = keysLeft;
        this.keysRight = keysRight;
    }

    public ITuplePairComparator createTuplePairComparator(IHyracksTaskContext ctx) {
        IBinaryComparator[] binaryComparators = new IBinaryComparator[this.binaryComparatorFactories.length];
        for (int i = 0; i < binaryComparators.length; ++i) {
            binaryComparators[i] = this.binaryComparatorFactories[i].createBinaryComparator();
        }
        return new JoinMultiComparator(binaryComparators, this.keysLeft, this.keysRight);
    }
}

