/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public final class ConstantExpression
extends AbstractLogicalExpression {
    private IAlgebricksConstantValue value;
    public static final ConstantExpression TRUE = new ConstantExpression(new IAlgebricksConstantValue(){

        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        public String toString() {
            return "TRUE";
        }
    });
    public static final ConstantExpression FALSE = new ConstantExpression(new IAlgebricksConstantValue(){

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return true;
        }

        public String toString() {
            return "FALSE";
        }
    });
    public static final ConstantExpression MISSING = new ConstantExpression(new IAlgebricksConstantValue(){

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        public String toString() {
            return "MISSING";
        }
    });
    private Map<Object, IExpressionAnnotation> annotationMap = new HashMap<Object, IExpressionAnnotation>();

    public ConstantExpression(IAlgebricksConstantValue value) {
        this.value = value;
    }

    public IAlgebricksConstantValue getValue() {
        return this.value;
    }

    public void setValue(IAlgebricksConstantValue value) {
        this.value = value;
    }

    @Override
    public LogicalExpressionTag getExpressionTag() {
        return LogicalExpressionTag.CONSTANT;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public void getUsedVariables(Collection<LogicalVariable> vars) {
    }

    @Override
    public void substituteVar(LogicalVariable v1, LogicalVariable v2) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantExpression)) {
            return false;
        }
        return this.value.equals(((ConstantExpression)obj).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public <R, T> R accept(ILogicalExpressionVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitConstantExpression(this, arg);
    }

    @Override
    public AbstractLogicalExpression cloneExpression() {
        HashMap<Object, IExpressionAnnotation> m = new HashMap<Object, IExpressionAnnotation>();
        this.annotationMap.forEach((key, value1) -> m.put(key, value1.copy()));
        ConstantExpression c = new ConstantExpression(this.value);
        c.annotationMap = m;
        c.setSourceLocation(this.sourceLoc);
        return c;
    }

    public Map<Object, IExpressionAnnotation> getAnnotations() {
        return this.annotationMap;
    }

    @Override
    public boolean splitIntoConjuncts(List<Mutable<ILogicalExpression>> conjs) {
        return false;
    }
}

