/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.sync;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.messaging.PartitionResourcesListResponse;
import org.apache.asterix.replication.messaging.PartitionResourcesListTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.replication.sync.FileSynchronizer;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;

public class ReplicaFilesSynchronizer {
    private final PartitionReplica replica;
    private final INcApplicationContext appCtx;

    public ReplicaFilesSynchronizer(INcApplicationContext appCtx, PartitionReplica replica) {
        this.appCtx = appCtx;
        this.replica = replica;
    }

    public void sync() throws IOException {
        int partition = this.replica.getIdentifier().getPartition();
        Set<String> replicaFiles = this.getReplicaFiles(partition);
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        IReplicationStrategy replicationStrategy = this.appCtx.getReplicationManager().getReplicationStrategy();
        Set masterFiles = localResourceRepository.getPartitionReplicatedFiles(partition, replicationStrategy).stream().map(StoragePathUtil::getFileRelativePath).collect(Collectors.toSet());
        List<String> replicaMissingFiles = masterFiles.stream().filter(file -> !replicaFiles.contains(file)).collect(Collectors.toList());
        this.replicateMissingFiles(replicaMissingFiles);
        List<String> replicaInvalidFiles = replicaFiles.stream().filter(file -> !masterFiles.contains(file)).collect(Collectors.toList());
        this.deleteInvalidFiles(replicaInvalidFiles);
    }

    private Set<String> getReplicaFiles(int partition) throws IOException {
        PartitionResourcesListTask replicaFilesRequest = new PartitionResourcesListTask(partition);
        SocketChannel channel = this.replica.getChannel();
        ByteBuffer reusableBuffer = this.replica.getReusableBuffer();
        ReplicationProtocol.sendTo(this.replica, replicaFilesRequest);
        PartitionResourcesListResponse response = (PartitionResourcesListResponse)ReplicationProtocol.read(channel, reusableBuffer);
        return new HashSet<String>(response.getResources());
    }

    private void replicateMissingFiles(List<String> files) {
        FileSynchronizer sync = new FileSynchronizer(this.appCtx, this.replica);
        files.sort(String::compareTo);
        files.forEach(sync::replicate);
    }

    private void deleteInvalidFiles(List<String> files) {
        FileSynchronizer sync = new FileSynchronizer(this.appCtx, this.replica);
        files.forEach(sync::delete);
    }
}

