/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationDestination
implements IReplicationDestination {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<IPartitionReplica> replicas = new HashSet<IPartitionReplica>();
    private final InetSocketAddress location;
    private SocketChannel logRepChannel;

    private ReplicationDestination(InetSocketAddress location) {
        this.location = location;
    }

    public static ReplicationDestination at(InetSocketAddress location) {
        return new ReplicationDestination(location);
    }

    public synchronized void add(IPartitionReplica replica) {
        this.replicas.add(replica);
    }

    public synchronized void remove(IPartitionReplica replica) {
        this.replicas.remove(replica);
    }

    public synchronized void notifyFailure(Exception failure) {
        this.replicas.forEach(replica -> replica.notifyFailure(failure));
        this.closeLogReplicationChannel();
    }

    public Set<IPartitionReplica> getReplicas() {
        return new HashSet<IPartitionReplica>(this.replicas);
    }

    public synchronized Optional<IPartitionReplica> getPartitionReplica(int partition) {
        return this.replicas.stream().filter(replica -> replica.getIdentifier().getPartition() == partition && replica.getStatus() == IPartitionReplica.PartitionReplicaStatus.IN_SYNC).findAny();
    }

    public synchronized SocketChannel getLogReplicationChannel() {
        try {
            if (this.logRepChannel == null || !this.logRepChannel.isOpen() || !this.logRepChannel.isConnected()) {
                this.logRepChannel = SocketChannel.open();
                NetworkUtil.configure((SocketChannel)this.logRepChannel);
                this.logRepChannel.configureBlocking(true);
                this.logRepChannel.connect(this.location);
            }
            return this.logRepChannel;
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private synchronized void closeLogReplicationChannel() {
        try {
            if (this.logRepChannel != null && this.logRepChannel.isOpen()) {
                ReplicationProtocol.sendGoodbye(this.logRepChannel);
                this.logRepChannel.close();
                this.logRepChannel = null;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Exception while closing socket", (Throwable)e);
        }
    }

    public InetSocketAddress getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationDestination that = (ReplicationDestination)o;
        return Objects.equals(this.location, that.location);
    }

    public String toString() {
        return this.location.toString();
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }
}

