/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.BulkloadPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.DataSourceScanPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.DistributeResultPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.EmptyTupleSourcePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.InMemoryStableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.IndexBulkloadPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.IndexInsertDeleteUpsertPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.InsertDeleteUpsertPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.IntersectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.LeftOuterUnnestPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroPreSortedDistinctByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroPreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroUnionAllPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.NestedTupleSourcePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PreSortedDistinctByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ReplicatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RunningAggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SinkPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SinkWritePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SplitPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamLimitPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamSelectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StringStreamingScriptPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SubplanPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.TokenizePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.UnionAllPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.UnnestPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.WriteResultPOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.rewriter.util.JoinUtils;

public class SetAlgebricksPhysicalOperatorsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getPhysicalOperator() != null) {
            return false;
        }
        SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp(op, true, context);
        return true;
    }

    private static void setPhysicalOperators(ILogicalPlan plan, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        for (Mutable root : plan.getRoots()) {
            SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)root.getValue(), topLevelOp, context);
        }
    }

    private static void computeDefaultPhysicalOp(AbstractLogicalOperator op, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        PhysicalOptimizationConfig physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
        if (op.getPhysicalOperator() == null) {
            switch (op.getOperatorTag()) {
                case AGGREGATE: {
                    op.setPhysicalOperator((IPhysicalOperator)new AggregatePOperator());
                    break;
                }
                case ASSIGN: {
                    op.setPhysicalOperator((IPhysicalOperator)new AssignPOperator());
                    break;
                }
                case DISTINCT: {
                    DistinctOperator distinct = (DistinctOperator)op;
                    if (topLevelOp) {
                        distinct.setPhysicalOperator((IPhysicalOperator)new PreSortedDistinctByPOperator(distinct.getDistinctByVarList()));
                        break;
                    }
                    distinct.setPhysicalOperator((IPhysicalOperator)new MicroPreSortedDistinctByPOperator(distinct.getDistinctByVarList()));
                    break;
                }
                case EMPTYTUPLESOURCE: {
                    op.setPhysicalOperator((IPhysicalOperator)new EmptyTupleSourcePOperator());
                    break;
                }
                case EXCHANGE: {
                    if (op.getPhysicalOperator() != null) break;
                    throw new AlgebricksException("Implementation for EXCHANGE operator was not set.");
                }
                case GROUP: {
                    ExternalGroupByPOperator externalGby;
                    ILogicalPlan p0;
                    GroupByOperator gby = (GroupByOperator)op;
                    if (gby.getNestedPlans().size() == 1 && (p0 = (ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().size() == 1 && (gby.getAnnotations().get("USE_HASH_GROUP_BY") == Boolean.TRUE || gby.getAnnotations().get("USE_EXTERNAL_GROUP_BY") == Boolean.TRUE)) {
                        if (!topLevelOp) {
                            throw new NotImplementedException("External hash group-by for nested grouping is not implemented.");
                        }
                        boolean hasIntermediateAgg = SetAlgebricksPhysicalOperatorsRule.generateMergeAggregationExpressions(gby, context);
                        if (hasIntermediateAgg) {
                            externalGby = new ExternalGroupByPOperator(gby.getGroupByList(), physicalOptimizationConfig.getMaxFramesForGroupBy(), (long)physicalOptimizationConfig.getMaxFramesForGroupBy() * (long)physicalOptimizationConfig.getFrameSize());
                            op.setPhysicalOperator((IPhysicalOperator)externalGby);
                            break;
                        }
                    }
                    List gbyList = gby.getGroupByList();
                    ArrayList<LogicalVariable> columnList = new ArrayList<LogicalVariable>(gbyList.size());
                    externalGby = gbyList.iterator();
                    while (externalGby.hasNext()) {
                        Pair p = (Pair)externalGby.next();
                        ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
                        if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                        VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                        columnList.add(varRef.getVariableReference());
                    }
                    if (topLevelOp) {
                        op.setPhysicalOperator((IPhysicalOperator)new PreclusteredGroupByPOperator(columnList, gby.isGroupAll(), context.getPhysicalOptimizationConfig().getMaxFramesForGroupBy()));
                        break;
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new MicroPreclusteredGroupByPOperator(columnList));
                    break;
                }
                case INNERJOIN: {
                    JoinUtils.setJoinAlgorithmAndExchangeAlgo((AbstractBinaryJoinOperator)((InnerJoinOperator)op), topLevelOp, context);
                    break;
                }
                case LEFTOUTERJOIN: {
                    JoinUtils.setJoinAlgorithmAndExchangeAlgo((AbstractBinaryJoinOperator)((LeftOuterJoinOperator)op), topLevelOp, context);
                    break;
                }
                case LIMIT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StreamLimitPOperator());
                    break;
                }
                case NESTEDTUPLESOURCE: {
                    op.setPhysicalOperator((IPhysicalOperator)new NestedTupleSourcePOperator());
                    break;
                }
                case ORDER: {
                    OrderOperator oo = (OrderOperator)op;
                    for (Pair p : oo.getOrderExpressions()) {
                        ILogicalExpression e = (ILogicalExpression)((Mutable)p.second).getValue();
                        if (e.getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
                        throw new AlgebricksException("Order expression " + e + " has not been normalized.");
                    }
                    if (topLevelOp) {
                        op.setPhysicalOperator((IPhysicalOperator)new StableSortPOperator(physicalOptimizationConfig.getMaxFramesExternalSort(), oo.getTopK()));
                        break;
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new InMemoryStableSortPOperator());
                    break;
                }
                case PROJECT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StreamProjectPOperator());
                    break;
                }
                case RUNNINGAGGREGATE: {
                    op.setPhysicalOperator((IPhysicalOperator)new RunningAggregatePOperator());
                    break;
                }
                case REPLICATE: {
                    op.setPhysicalOperator((IPhysicalOperator)new ReplicatePOperator());
                    break;
                }
                case SPLIT: {
                    op.setPhysicalOperator((IPhysicalOperator)new SplitPOperator());
                    break;
                }
                case SCRIPT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StringStreamingScriptPOperator());
                    break;
                }
                case SELECT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StreamSelectPOperator());
                    break;
                }
                case SUBPLAN: {
                    op.setPhysicalOperator((IPhysicalOperator)new SubplanPOperator());
                    break;
                }
                case UNIONALL: {
                    if (topLevelOp) {
                        op.setPhysicalOperator((IPhysicalOperator)new UnionAllPOperator());
                        break;
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new MicroUnionAllPOperator());
                    break;
                }
                case INTERSECT: {
                    if (topLevelOp) {
                        op.setPhysicalOperator((IPhysicalOperator)new IntersectPOperator());
                        break;
                    }
                    throw new IllegalStateException("Micro operator not implemented for: " + op.getOperatorTag());
                }
                case UNNEST: {
                    op.setPhysicalOperator((IPhysicalOperator)new UnnestPOperator());
                    break;
                }
                case LEFT_OUTER_UNNEST: {
                    op.setPhysicalOperator((IPhysicalOperator)new LeftOuterUnnestPOperator());
                    break;
                }
                case DATASOURCESCAN: {
                    DataSourceScanOperator scan = (DataSourceScanOperator)op;
                    IDataSource dataSource = scan.getDataSource();
                    DataSourceScanPOperator dss = new DataSourceScanPOperator(dataSource);
                    if (dataSource.isScanAccessPathALeaf()) {
                        dss.disableJobGenBelowMe();
                    }
                    op.setPhysicalOperator((IPhysicalOperator)dss);
                    break;
                }
                case WRITE: {
                    op.setPhysicalOperator((IPhysicalOperator)new SinkWritePOperator());
                    break;
                }
                case DISTRIBUTE_RESULT: {
                    op.setPhysicalOperator((IPhysicalOperator)new DistributeResultPOperator());
                    break;
                }
                case WRITE_RESULT: {
                    WriteResultOperator opLoad = (WriteResultOperator)op;
                    ArrayList<LogicalVariable> keys = new ArrayList<LogicalVariable>();
                    ArrayList<Object> additionalFilteringKeys = null;
                    LogicalVariable payload = SetAlgebricksPhysicalOperatorsRule.getKeysAndLoad((Mutable<ILogicalExpression>)opLoad.getPayloadExpression(), opLoad.getKeyExpressions(), keys);
                    if (opLoad.getAdditionalFilteringExpressions() != null) {
                        additionalFilteringKeys = new ArrayList<LogicalVariable>();
                        SetAlgebricksPhysicalOperatorsRule.getKeys(opLoad.getAdditionalFilteringExpressions(), additionalFilteringKeys);
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new WriteResultPOperator(opLoad.getDataSource(), payload, keys, additionalFilteringKeys));
                    break;
                }
                case INSERT_DELETE_UPSERT: {
                    WriteResultOperator opLoad = (InsertDeleteUpsertOperator)op;
                    ArrayList<LogicalVariable> keys = new ArrayList<LogicalVariable>();
                    ArrayList<Object> additionalFilteringKeys = null;
                    ArrayList<LogicalVariable> additionalNonFilterVariables = null;
                    if (opLoad.getAdditionalNonFilteringExpressions() != null) {
                        additionalNonFilterVariables = new ArrayList<LogicalVariable>();
                        SetAlgebricksPhysicalOperatorsRule.getKeys(opLoad.getAdditionalNonFilteringExpressions(), additionalNonFilterVariables);
                    }
                    LogicalVariable payload = SetAlgebricksPhysicalOperatorsRule.getKeysAndLoad((Mutable<ILogicalExpression>)opLoad.getPayloadExpression(), opLoad.getPrimaryKeyExpressions(), keys);
                    if (opLoad.getAdditionalFilteringExpressions() != null) {
                        additionalFilteringKeys = new ArrayList();
                        SetAlgebricksPhysicalOperatorsRule.getKeys(opLoad.getAdditionalFilteringExpressions(), additionalFilteringKeys);
                    }
                    if (opLoad.isBulkload()) {
                        op.setPhysicalOperator((IPhysicalOperator)new BulkloadPOperator(payload, keys, additionalFilteringKeys, additionalNonFilterVariables, opLoad.getDataSource()));
                        break;
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new InsertDeleteUpsertPOperator(payload, keys, additionalFilteringKeys, opLoad.getDataSource(), opLoad.getOperation(), additionalNonFilterVariables));
                    break;
                }
                case INDEX_INSERT_DELETE_UPSERT: {
                    IndexInsertDeleteUpsertOperator opInsDel = (IndexInsertDeleteUpsertOperator)op;
                    ArrayList<LogicalVariable> primaryKeys = new ArrayList();
                    ArrayList<LogicalVariable> secondaryKeys = new ArrayList<LogicalVariable>();
                    ArrayList<Object> additionalFilteringKeys = null;
                    SetAlgebricksPhysicalOperatorsRule.getKeys(opInsDel.getPrimaryKeyExpressions(), primaryKeys);
                    SetAlgebricksPhysicalOperatorsRule.getKeys(opInsDel.getSecondaryKeyExpressions(), secondaryKeys);
                    if (opInsDel.getAdditionalFilteringExpressions() != null) {
                        additionalFilteringKeys = new ArrayList();
                        SetAlgebricksPhysicalOperatorsRule.getKeys(opInsDel.getAdditionalFilteringExpressions(), additionalFilteringKeys);
                    }
                    if (opInsDel.isBulkload()) {
                        op.setPhysicalOperator((IPhysicalOperator)new IndexBulkloadPOperator(primaryKeys, secondaryKeys, additionalFilteringKeys, opInsDel.getFilterExpression(), opInsDel.getDataSourceIndex()));
                        break;
                    }
                    LogicalVariable upsertIndicatorVar = null;
                    ArrayList<LogicalVariable> prevSecondaryKeys = null;
                    LogicalVariable prevAdditionalFilteringKey = null;
                    if (opInsDel.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                        upsertIndicatorVar = SetAlgebricksPhysicalOperatorsRule.getKey((ILogicalExpression)opInsDel.getUpsertIndicatorExpr().getValue());
                        prevSecondaryKeys = new ArrayList<LogicalVariable>();
                        SetAlgebricksPhysicalOperatorsRule.getKeys(opInsDel.getPrevSecondaryKeyExprs(), prevSecondaryKeys);
                        if (opInsDel.getPrevAdditionalFilteringExpression() != null) {
                            prevAdditionalFilteringKey = ((VariableReferenceExpression)opInsDel.getPrevAdditionalFilteringExpression().getValue()).getVariableReference();
                        }
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new IndexInsertDeleteUpsertPOperator(primaryKeys, secondaryKeys, additionalFilteringKeys, opInsDel.getFilterExpression(), opInsDel.getDataSourceIndex(), upsertIndicatorVar, prevSecondaryKeys, prevAdditionalFilteringKey, opInsDel.getNumberOfAdditionalNonFilteringFields()));
                    break;
                }
                case TOKENIZE: {
                    TokenizeOperator opTokenize = (TokenizeOperator)op;
                    ArrayList<LogicalVariable> primaryKeys = new ArrayList<LogicalVariable>();
                    ArrayList<LogicalVariable> secondaryKeys = new ArrayList<LogicalVariable>();
                    SetAlgebricksPhysicalOperatorsRule.getKeys(opTokenize.getPrimaryKeyExpressions(), primaryKeys);
                    SetAlgebricksPhysicalOperatorsRule.getKeys(opTokenize.getSecondaryKeyExpressions(), secondaryKeys);
                    if (!opTokenize.isBulkload()) break;
                    op.setPhysicalOperator((IPhysicalOperator)new TokenizePOperator(primaryKeys, secondaryKeys, opTokenize.getDataSourceIndex()));
                    break;
                }
                case SINK: {
                    op.setPhysicalOperator((IPhysicalOperator)new SinkPOperator());
                }
            }
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                SetAlgebricksPhysicalOperatorsRule.setPhysicalOperators(p, false, context);
            }
        }
        for (Mutable opRef : op.getInputs()) {
            SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)opRef.getValue(), topLevelOp, context);
        }
    }

    private static void getKeys(List<Mutable<ILogicalExpression>> keyExpressions, List<LogicalVariable> keys) {
        for (Mutable<ILogicalExpression> kExpr : keyExpressions) {
            keys.add(SetAlgebricksPhysicalOperatorsRule.getKey((ILogicalExpression)kExpr.getValue()));
        }
    }

    private static LogicalVariable getKey(ILogicalExpression keyExpression) {
        if (keyExpression.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            throw new NotImplementedException();
        }
        return ((VariableReferenceExpression)keyExpression).getVariableReference();
    }

    private static LogicalVariable getKeysAndLoad(Mutable<ILogicalExpression> payloadExpr, List<Mutable<ILogicalExpression>> keyExpressions, List<LogicalVariable> keys) {
        if (((ILogicalExpression)payloadExpr.getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            throw new NotImplementedException();
        }
        LogicalVariable payload = ((VariableReferenceExpression)payloadExpr.getValue()).getVariableReference();
        for (Mutable<ILogicalExpression> kExpr : keyExpressions) {
            ILogicalExpression e = (ILogicalExpression)kExpr.getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new NotImplementedException();
            }
            keys.add(((VariableReferenceExpression)e).getVariableReference());
        }
        return payload;
    }

    private static boolean generateMergeAggregationExpressions(GroupByOperator gby, IOptimizationContext context) throws AlgebricksException {
        if (gby.getNestedPlans().size() != 1) {
            throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        ILogicalPlan p0 = (ILogicalPlan)gby.getNestedPlans().get(0);
        if (p0.getRoots().size() != 1) {
            throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = context.getMergeAggregationExpressionFactory();
        Mutable r0 = (Mutable)p0.getRoots().get(0);
        AbstractLogicalOperator r0Logical = (AbstractLogicalOperator)r0.getValue();
        if (r0Logical.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AbstractLogicalOperator r1Logical = r0Logical;
        while (r1Logical.hasInputs()) {
            if ((r1Logical = (ILogicalOperator)((Mutable)r1Logical.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE) continue;
            return false;
        }
        AggregateOperator aggOp = (AggregateOperator)r0.getValue();
        List aggFuncRefs = aggOp.getExpressions();
        List originalAggVars = aggOp.getVariables();
        int n = aggOp.getExpressions().size();
        ArrayList<MutableObject> mergeExpressionRefs = new ArrayList<MutableObject>();
        for (int i = 0; i < n; ++i) {
            ILogicalExpression mergeExpr = mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)originalAggVars.get(i), (ILogicalExpression)((Mutable)aggFuncRefs.get(i)).getValue(), context);
            if (mergeExpr == null) {
                return false;
            }
            mergeExpressionRefs.add(new MutableObject((Object)mergeExpr));
        }
        aggOp.setMergeExpressions(mergeExpressionRefs);
        return true;
    }
}

