/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractStableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SortGroupByPOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushGroupByIntoSortRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op1 = (ILogicalOperator)opRef.getValue();
        if (op1 == null) {
            return false;
        }
        boolean changed = false;
        for (Mutable childRef : op1.getInputs()) {
            boolean hasIntermediateAggregate;
            AggregateOperator aggOp;
            AbstractLogicalOperator aggInputOp;
            Mutable r0;
            AbstractLogicalOperator r0Logical;
            ILogicalPlan p0;
            Mutable op2Ref;
            AbstractLogicalOperator op2;
            AbstractLogicalOperator op = (AbstractLogicalOperator)childRef.getValue();
            if (op.getOperatorTag() != LogicalOperatorTag.GROUP) continue;
            PhysicalOperatorTag opTag = op.getPhysicalOperator().getOperatorTag();
            GroupByOperator groupByOperator = (GroupByOperator)op;
            if (opTag != PhysicalOperatorTag.PRE_CLUSTERED_GROUP_BY || (op2 = (AbstractLogicalOperator)(op2Ref = (Mutable)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getInputs().get(0)).getValue()).getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.STABLE_SORT) continue;
            AbstractStableSortPOperator sortPhysicalOperator = (AbstractStableSortPOperator)op2.getPhysicalOperator();
            if (groupByOperator.getNestedPlans().size() != 1 || (p0 = (ILogicalPlan)groupByOperator.getNestedPlans().get(0)).getRoots().size() != 1 || (r0Logical = (AbstractLogicalOperator)(r0 = (Mutable)p0.getRoots().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE || (aggInputOp = (AbstractLogicalOperator)((Mutable)(aggOp = (AggregateOperator)r0.getValue()).getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE || !(hasIntermediateAggregate = this.generateMergeAggregationExpressions(groupByOperator, context))) continue;
            if (!groupByOperator.isGroupAll()) {
                op.setPhysicalOperator((IPhysicalOperator)new SortGroupByPOperator(groupByOperator.getGroupByList(), context.getPhysicalOptimizationConfig().getMaxFramesForGroupBy(), sortPhysicalOperator.getSortColumns()));
            }
            op.getInputs().clear();
            op.getInputs().addAll(op2.getInputs());
            changed = true;
        }
        return changed;
    }

    private boolean generateMergeAggregationExpressions(GroupByOperator gby, IOptimizationContext context) throws AlgebricksException {
        if (gby.getNestedPlans().size() != 1) {
            throw new AlgebricksException("External/sort group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        ILogicalPlan p0 = (ILogicalPlan)gby.getNestedPlans().get(0);
        if (p0.getRoots().size() != 1) {
            throw new AlgebricksException("External/sort group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = context.getMergeAggregationExpressionFactory();
        Mutable r0 = (Mutable)p0.getRoots().get(0);
        AggregateOperator aggOp = (AggregateOperator)r0.getValue();
        List aggFuncRefs = aggOp.getExpressions();
        List originalAggVars = aggOp.getVariables();
        int n = aggOp.getExpressions().size();
        ArrayList<MutableObject> mergeExpressionRefs = new ArrayList<MutableObject>();
        for (int i = 0; i < n; ++i) {
            ILogicalExpression mergeExpr = mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)originalAggVars.get(i), (ILogicalExpression)((Mutable)aggFuncRefs.get(i)).getValue(), context);
            if (mergeExpr == null) {
                return false;
            }
            mergeExpressionRefs.add(new MutableObject((Object)mergeExpr));
        }
        aggOp.setMergeExpressions(mergeExpressionRefs);
        return true;
    }
}

