/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.FDsAndEquivClassesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPreSortedDistinctByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractStableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.BroadcastExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HashPartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HashPartitionMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.InMemoryStableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RandomMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RandomPartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RangePartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RangePartitionMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SortMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AbstractLogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.PropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.data.partition.range.IRangeMap;

public class EnforceStructuralPropertiesRule
implements IAlgebraicRewriteRule {
    private static final String HASH_MERGE = "hash_merge";
    private static final String TRUE_CONSTANT = "true";
    private PhysicalOptimizationConfig physicalOptimizationConfig;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getPhysicalOperator() == null) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        List fds = context.getFDList((ILogicalOperator)op);
        if (fds != null && !fds.isEmpty()) {
            return false;
        }
        this.physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Optimizing operator " + op.getPhysicalOperator() + ".\n");
        }
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses((ILogicalOperator)op, context);
        StructuralPropertiesVector pvector = new StructuralPropertiesVector((IPartitioningProperty)new RandomPartitioningProperty(context.getComputationNodeDomain()), new LinkedList());
        boolean changed = this.physOptimizeOp(opRef, (IPhysicalPropertiesVector)pvector, false, context);
        op.computeDeliveredPhysicalProperties(context);
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Structural properties for " + op.getPhysicalOperator() + ": " + op.getDeliveredPhysicalProperties() + "\n");
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        return changed;
    }

    private boolean physOptimizePlan(ILogicalPlan plan, IPhysicalPropertiesVector pvector, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        boolean loggerTraceEnabled = AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled();
        boolean changed = false;
        for (Mutable root : plan.getRoots()) {
            if (this.physOptimizeOp((Mutable<ILogicalOperator>)root, pvector, nestedPlan, context)) {
                changed = true;
            }
            AbstractLogicalOperator op = (AbstractLogicalOperator)root.getValue();
            op.computeDeliveredPhysicalProperties(context);
            if (!loggerTraceEnabled) continue;
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Structural properties for " + op.getPhysicalOperator() + ": " + op.getDeliveredPhysicalProperties() + "\n");
        }
        return changed;
    }

    private int getStartChildIndex(AbstractLogicalOperator op, PhysicalRequirements pr, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        IPhysicalPropertiesVector[] reqdProperties = null;
        if (pr != null) {
            reqdProperties = pr.getRequiredProperties();
        }
        ArrayList<IPartitioningProperty> deliveredPartitioningPropertiesFromChildren = new ArrayList<IPartitioningProperty>();
        for (Mutable childRef : op.getInputs()) {
            AbstractLogicalOperator child = (AbstractLogicalOperator)childRef.getValue();
            deliveredPartitioningPropertiesFromChildren.add(child.getDeliveredPhysicalProperties().getPartitioningProperty());
        }
        int partitioningCompatibleChild = 0;
        for (int i = 0; i < op.getInputs().size(); ++i) {
            IPartitioningProperty requiredPropertyForChild;
            IPartitioningProperty deliveredPropertyFromChild = (IPartitioningProperty)deliveredPartitioningPropertiesFromChildren.get(i);
            if (reqdProperties == null || reqdProperties[i] == null || reqdProperties[i].getPartitioningProperty() == null || deliveredPropertyFromChild == null || reqdProperties[i].getPartitioningProperty().getPartitioningType() != ((IPartitioningProperty)deliveredPartitioningPropertiesFromChildren.get(i)).getPartitioningType() || !PropertiesUtil.matchPartitioningProps((IPartitioningProperty)(requiredPropertyForChild = reqdProperties[i].getPartitioningProperty()), (IPartitioningProperty)deliveredPropertyFromChild, (boolean)true)) continue;
            partitioningCompatibleChild = i;
            break;
        }
        return partitioningCompatibleChild;
    }

    private boolean physOptimizeOp(Mutable<ILogicalOperator> opRef, IPhysicalPropertiesVector required, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        this.optimizeUsingConstraintsAndEquivClasses(op);
        PhysicalRequirements pr = op.getRequiredPhysicalPropertiesForChildren(required, context);
        IPhysicalPropertiesVector[] reqdProperties = null;
        if (pr != null) {
            reqdProperties = pr.getRequiredProperties();
        }
        boolean opIsRedundantSort = false;
        INodeDomain childrenDomain = null;
        int j = 0;
        for (Mutable childRef : op.getInputs()) {
            AbstractLogicalOperator child = (AbstractLogicalOperator)childRef.getValue();
            if (this.physOptimizeOp((Mutable<ILogicalOperator>)childRef, reqdProperties[j], nestedPlan, context)) {
                changed = true;
            }
            child.computeDeliveredPhysicalProperties(context);
            IPhysicalPropertiesVector delivered = child.getDeliveredPhysicalProperties();
            if (childrenDomain == null) {
                childrenDomain = delivered.getPartitioningProperty().getNodeDomain();
            } else {
                INodeDomain dom2 = delivered.getPartitioningProperty().getNodeDomain();
                if (!childrenDomain.sameAs(dom2)) {
                    childrenDomain = context.getComputationNodeDomain();
                }
            }
            ++j;
        }
        if (reqdProperties != null) {
            for (int k = 0; k < reqdProperties.length; ++k) {
                IPhysicalPropertiesVector pv = reqdProperties[k];
                IPartitioningProperty pp = pv.getPartitioningProperty();
                if (pp == null || pp.getNodeDomain() != null) continue;
                pp.setNodeDomain(childrenDomain);
            }
        }
        boolean loggerTraceEnabled = AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled();
        int startChildIndex = this.getStartChildIndex(op, pr, nestedPlan, context);
        IPartitioningProperty firstDeliveredPartitioning = null;
        for (int j2 = 0; j2 < op.getInputs().size(); ++j2) {
            IPhysicalPropertiesVector diff;
            int childIndex = (j2 + startChildIndex) % op.getInputs().size();
            IPhysicalPropertiesVector requiredProperty = reqdProperties[childIndex];
            AbstractLogicalOperator child = (AbstractLogicalOperator)((Mutable)op.getInputs().get(childIndex)).getValue();
            IPhysicalPropertiesVector delivered = child.getDeliveredPhysicalProperties();
            if (loggerTraceEnabled) {
                AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Properties delivered by " + child.getPhysicalOperator() + ": " + delivered + "\n");
            }
            IPartitioningRequirementsCoordinator prc = pr.getPartitioningCoordinator();
            Pair pbpp = prc.coordinateRequirements(requiredProperty.getPartitioningProperty(), firstDeliveredPartitioning, (ILogicalOperator)op, context);
            boolean mayExpandPartitioningProperties = (Boolean)pbpp.first;
            StructuralPropertiesVector rqd = new StructuralPropertiesVector((IPartitioningProperty)pbpp.second, requiredProperty.getLocalProperties());
            if (loggerTraceEnabled) {
                AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Required properties for " + child.getPhysicalOperator() + ": " + rqd + "\n");
            }
            if (this.isRedundantSort(opRef, delivered, diff = delivered.getUnsatisfiedPropertiesFrom((IPhysicalPropertiesVector)rqd, mayExpandPartitioningProperties, context.getEquivalenceClassMap((ILogicalOperator)child), context.getFDList((ILogicalOperator)child)), context)) {
                opIsRedundantSort = true;
            }
            if (diff != null) {
                changed = true;
                this.addEnforcers(op, childIndex, diff, (IPhysicalPropertiesVector)rqd, delivered, childrenDomain, nestedPlan, context);
                AbstractLogicalOperator newChild = (AbstractLogicalOperator)((Mutable)op.getInputs().get(childIndex)).getValue();
                if (newChild != child) {
                    delivered = newChild.getDeliveredPhysicalProperties();
                    IPhysicalPropertiesVector newDiff = this.newPropertiesDiff(newChild, (IPhysicalPropertiesVector)rqd, mayExpandPartitioningProperties, context);
                    if (loggerTraceEnabled) {
                        AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> New properties diff: " + newDiff + "\n");
                    }
                    if (this.isRedundantSort(opRef, delivered, newDiff, context)) {
                        opIsRedundantSort = true;
                        break;
                    }
                }
            }
            if (firstDeliveredPartitioning != null) continue;
            firstDeliveredPartitioning = delivered.getPartitioningProperty();
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                if (!this.physOptimizePlan(p, required, true, context)) continue;
                changed = true;
            }
        }
        if (opIsRedundantSort) {
            if (loggerTraceEnabled) {
                AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Removing redundant SORT operator " + op.getPhysicalOperator() + "\n");
                this.printOp(op);
            }
            changed = true;
            AbstractLogicalOperator nextOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            if (nextOp.getOperatorTag() == LogicalOperatorTag.PROJECT) {
                nextOp = (AbstractLogicalOperator)((Mutable)nextOp.getInputs().get(0)).getValue();
            }
            opRef.setValue((Object)nextOp);
            AbstractLogicalOperator transferTo = nextOp;
            if (transferTo.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                transferTo = (AbstractLogicalOperator)((Mutable)transferTo.getInputs().get(0)).getValue();
            }
            transferTo.getAnnotations().putAll(op.getAnnotations());
            this.physOptimizeOp(opRef, required, nestedPlan, context);
        }
        return changed;
    }

    private IPhysicalPropertiesVector newPropertiesDiff(AbstractLogicalOperator newChild, IPhysicalPropertiesVector required, boolean mayExpandPartitioningProperties, IOptimizationContext context) throws AlgebricksException {
        IPhysicalPropertiesVector newDelivered = newChild.getDeliveredPhysicalProperties();
        Map newChildEqClasses = context.getEquivalenceClassMap((ILogicalOperator)newChild);
        List newChildFDs = context.getFDList((ILogicalOperator)newChild);
        if (newChildEqClasses == null || newChildFDs == null) {
            FDsAndEquivClassesVisitor fdsVisitor = new FDsAndEquivClassesVisitor();
            newChild.accept((ILogicalOperatorVisitor)fdsVisitor, (Object)context);
            newChildEqClasses = context.getEquivalenceClassMap((ILogicalOperator)newChild);
            newChildFDs = context.getFDList((ILogicalOperator)newChild);
        }
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Required properties for new op. " + newChild.getPhysicalOperator() + ": " + required + "\n");
        }
        return newDelivered.getUnsatisfiedPropertiesFrom(required, mayExpandPartitioningProperties, newChildEqClasses, newChildFDs);
    }

    private void optimizeUsingConstraintsAndEquivClasses(AbstractLogicalOperator op) {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        switch (pOp.getOperatorTag()) {
            case HASH_GROUP_BY: 
            case EXTERNAL_GROUP_BY: {
                GroupByOperator gby = (GroupByOperator)op;
                ExternalGroupByPOperator hgbyOp = (ExternalGroupByPOperator)pOp;
                hgbyOp.computeColumnSet(gby.getGroupByList());
                break;
            }
            case PRE_CLUSTERED_GROUP_BY: 
            case MICRO_PRE_CLUSTERED_GROUP_BY: {
                GroupByOperator gby = (GroupByOperator)op;
                AbstractPreclusteredGroupByPOperator preSortedGby = (AbstractPreclusteredGroupByPOperator)pOp;
                preSortedGby.setGbyColumns(gby.getGbyVarList());
                break;
            }
            case PRE_SORTED_DISTINCT_BY: 
            case MICRO_PRE_SORTED_DISTINCT_BY: {
                DistinctOperator d = (DistinctOperator)op;
                AbstractPreSortedDistinctByPOperator preSortedDistinct = (AbstractPreSortedDistinctByPOperator)pOp;
                preSortedDistinct.setDistinctByColumns(d.getDistinctByVarList());
                break;
            }
        }
    }

    private List<OrderColumn> getOrderColumnsFromGroupingProperties(List<ILocalStructuralProperty> reqd, List<ILocalStructuralProperty> dlvd) {
        int j;
        int prefix;
        ArrayList<OrderColumn> returnedProperties = new ArrayList<OrderColumn>();
        ArrayList rqdCols = new ArrayList();
        ArrayList dlvdCols = new ArrayList();
        for (ILocalStructuralProperty r : reqd) {
            r.getVariables(rqdCols);
        }
        for (ILocalStructuralProperty d : dlvd) {
            d.getVariables(dlvdCols);
        }
        for (prefix = dlvdCols.size() - 1; prefix >= 0 && !rqdCols.contains(dlvdCols.get(prefix)); --prefix) {
        }
        LocalOrderProperty orderProp = (LocalOrderProperty)dlvd.get(0);
        List orderColumns = orderProp.getOrderColumns();
        for (j = 0; j <= prefix; ++j) {
            returnedProperties.add(new OrderColumn(((OrderColumn)orderColumns.get(j)).getColumn(), ((OrderColumn)orderColumns.get(j)).getOrder()));
        }
        if (!returnedProperties.isEmpty()) {
            for (j = prefix + 1; j < dlvdCols.size(); ++j) {
                OrderColumn oc = (OrderColumn)orderColumns.get(j);
                returnedProperties.add(new OrderColumn(oc.getColumn(), oc.getOrder()));
            }
        }
        return returnedProperties;
    }

    private boolean isRedundantSort(Mutable<ILogicalOperator> opRef, IPhysicalPropertiesVector delivered, IPhysicalPropertiesVector diffOfProperties, IOptimizationContext context) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ORDER || op.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.STABLE_SORT && op.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.IN_MEMORY_STABLE_SORT || delivered.getLocalProperties() == null) {
            return false;
        }
        AbstractStableSortPOperator sortOp = (AbstractStableSortPOperator)op.getPhysicalOperator();
        sortOp.computeLocalProperties((ILogicalOperator)op);
        ILocalStructuralProperty orderProp = sortOp.getOrderProperty();
        return PropertiesUtil.matchLocalProperties(Collections.singletonList(orderProp), (List)delivered.getLocalProperties(), (Map)context.getEquivalenceClassMap((ILogicalOperator)op), (List)context.getFDList((ILogicalOperator)op));
    }

    private void addEnforcers(AbstractLogicalOperator op, int childIndex, IPhysicalPropertiesVector diffPropertiesVector, IPhysicalPropertiesVector required, IPhysicalPropertiesVector deliveredByChild, INodeDomain domain, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        IPartitioningProperty pp = diffPropertiesVector.getPartitioningProperty();
        if (pp == null || pp.getPartitioningType() == IPartitioningProperty.PartitioningType.UNPARTITIONED) {
            this.addLocalEnforcers(op, childIndex, diffPropertiesVector.getLocalProperties(), nestedPlan, context);
            IPhysicalPropertiesVector deliveredByNewChild = ((AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getDeliveredPhysicalProperties();
            if (!nestedPlan) {
                this.addPartitioningEnforcers((ILogicalOperator)op, childIndex, pp, required, deliveredByNewChild, domain, context);
            }
        } else {
            if (!nestedPlan) {
                this.addPartitioningEnforcers((ILogicalOperator)op, childIndex, pp, required, deliveredByChild, pp.getNodeDomain(), context);
            }
            AbstractLogicalOperator newChild = (AbstractLogicalOperator)((Mutable)op.getInputs().get(childIndex)).getValue();
            IPhysicalPropertiesVector newDiff = this.newPropertiesDiff(newChild, required, true, context);
            if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
                AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> New properties diff: " + newDiff + "\n");
            }
            if (newDiff != null) {
                this.addLocalEnforcers(op, childIndex, newDiff.getLocalProperties(), nestedPlan, context);
            }
        }
    }

    private void addLocalEnforcers(AbstractLogicalOperator op, int i, List<ILocalStructuralProperty> localProperties, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Adding local enforcers for local props = " + localProperties + "\n");
        }
        if (localProperties == null || localProperties.isEmpty()) {
            return;
        }
        Mutable<ILogicalOperator> topOp = new Mutable<ILogicalOperator>();
        topOp.setValue(((Mutable)op.getInputs().get(i)).getValue());
        LinkedList<LocalOrderProperty> oList = new LinkedList<LocalOrderProperty>();
        block4: for (ILocalStructuralProperty prop : localProperties) {
            switch (prop.getPropertyType()) {
                case LOCAL_ORDER_PROPERTY: {
                    oList.add((LocalOrderProperty)prop);
                    continue block4;
                }
                case LOCAL_GROUPING_PROPERTY: {
                    LocalGroupingProperty g = (LocalGroupingProperty)prop;
                    Collection vars = g.getPreferredOrderEnforcer() != null ? g.getPreferredOrderEnforcer() : g.getColumnSet();
                    ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
                    for (LogicalVariable v : vars) {
                        OrderColumn oc = new OrderColumn(v, OrderOperator.IOrder.OrderKind.ASC);
                        orderColumns.add(oc);
                    }
                    LocalOrderProperty lop = new LocalOrderProperty(orderColumns);
                    oList.add(lop);
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
        if (!oList.isEmpty()) {
            topOp = this.enforceOrderProperties(oList, topOp, nestedPlan, context);
        }
        op.getInputs().set(i, topOp);
        OperatorPropertiesUtil.computeSchemaAndPropertiesRecIfNull((AbstractLogicalOperator)((AbstractLogicalOperator)topOp.getValue()), (IOptimizationContext)context);
        OperatorManipulationUtil.setOperatorMode((AbstractLogicalOperator)op);
        this.printOp((AbstractLogicalOperator)topOp.getValue());
    }

    private Mutable<ILogicalOperator> enforceOrderProperties(List<LocalOrderProperty> oList, Mutable<ILogicalOperator> topOp, boolean isMicroOp, IOptimizationContext context) throws AlgebricksException {
        SourceLocation sourceLoc = ((ILogicalOperator)topOp.getValue()).getSourceLocation();
        LinkedList<Pair> oe = new LinkedList<Pair>();
        for (LocalOrderProperty orderProperty : oList) {
            for (OrderColumn oc : orderProperty.getOrderColumns()) {
                OrderOperator.IOrder ordType = oc.getOrder() == OrderOperator.IOrder.OrderKind.ASC ? OrderOperator.ASC_ORDER : OrderOperator.DESC_ORDER;
                VariableReferenceExpression ocColumnRef = new VariableReferenceExpression(oc.getColumn());
                ocColumnRef.setSourceLocation(sourceLoc);
                Pair pair = new Pair((Object)ordType, (Object)new MutableObject((Object)ocColumnRef));
                oe.add(pair);
            }
        }
        OrderOperator oo = new OrderOperator(oe);
        oo.setSourceLocation(sourceLoc);
        oo.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        if (isMicroOp) {
            oo.setPhysicalOperator((IPhysicalOperator)new InMemoryStableSortPOperator());
        } else {
            oo.setPhysicalOperator((IPhysicalOperator)new StableSortPOperator(this.physicalOptimizationConfig.getMaxFramesExternalSort()));
        }
        oo.getInputs().add(topOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)oo);
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Added sort enforcer " + oo.getPhysicalOperator() + ".\n");
        }
        return new MutableObject((Object)oo);
    }

    private void addPartitioningEnforcers(ILogicalOperator op, int i, IPartitioningProperty pp, IPhysicalPropertiesVector required, IPhysicalPropertiesVector deliveredByChild, INodeDomain domain, IOptimizationContext context) throws AlgebricksException {
        if (pp != null) {
            BroadcastExchangePOperator pop;
            switch (pp.getPartitioningType()) {
                case UNPARTITIONED: {
                    List<OrderColumn> ordCols = this.computeOrderColumns(deliveredByChild);
                    if (ordCols.isEmpty()) {
                        pop = new RandomMergeExchangePOperator();
                        break;
                    }
                    if (op.getAnnotations().containsKey("USE_RANGE_CONNECTOR")) {
                        IRangeMap rangeMap = (IRangeMap)op.getAnnotations().get("USE_RANGE_CONNECTOR");
                        pop = new RangePartitionMergeExchangePOperator(ordCols, domain, rangeMap);
                        break;
                    }
                    OrderColumn[] sortColumns = new OrderColumn[ordCols.size()];
                    sortColumns = ordCols.toArray(sortColumns);
                    pop = new SortMergeExchangePOperator(sortColumns);
                    break;
                }
                case UNORDERED_PARTITIONED: {
                    List fds;
                    AbstractLogicalOperator c;
                    Map ecs;
                    ArrayList varList = new ArrayList(((UnorderedPartitionedProperty)pp).getColumnSet());
                    String hashMergeHint = (String)context.getMetadataProvider().getConfig().get(HASH_MERGE);
                    if (hashMergeHint == null || !hashMergeHint.equalsIgnoreCase(TRUE_CONSTANT)) {
                        pop = new HashPartitionExchangePOperator(varList, domain);
                        break;
                    }
                    List cldLocals = deliveredByChild.getLocalProperties();
                    List reqdLocals = required.getLocalProperties();
                    boolean propWasSet = false;
                    pop = null;
                    if (reqdLocals != null && cldLocals != null && this.allAreOrderProps(cldLocals) && PropertiesUtil.matchLocalProperties((List)reqdLocals, (List)cldLocals, (Map)(ecs = context.getEquivalenceClassMap((ILogicalOperator)(c = (AbstractLogicalOperator)((Mutable)op.getInputs().get(i)).getValue()))), (List)(fds = context.getFDList((ILogicalOperator)c)))) {
                        List<OrderColumn> orderColumns = this.getOrderColumnsFromGroupingProperties(reqdLocals, cldLocals);
                        pop = new HashPartitionMergeExchangePOperator(orderColumns, varList, domain);
                        propWasSet = true;
                    }
                    if (propWasSet) break;
                    pop = new HashPartitionExchangePOperator(varList, domain);
                    break;
                }
                case ORDERED_PARTITIONED: {
                    pop = new RangePartitionExchangePOperator(((OrderedPartitionedProperty)pp).getOrderColumns(), domain, null);
                    break;
                }
                case BROADCAST: {
                    pop = new BroadcastExchangePOperator(domain);
                    break;
                }
                case RANDOM: {
                    RandomPartitioningProperty rpp = (RandomPartitioningProperty)pp;
                    INodeDomain nd = rpp.getNodeDomain();
                    pop = new RandomPartitionExchangePOperator(nd);
                    break;
                }
                default: {
                    throw new NotImplementedException("Enforcer for " + pp.getPartitioningType() + " partitioning type has not been implemented.");
                }
            }
            Mutable ci = (Mutable)op.getInputs().get(i);
            ExchangeOperator exchg = new ExchangeOperator();
            exchg.setPhysicalOperator((IPhysicalOperator)pop);
            this.setNewOp((Mutable<ILogicalOperator>)ci, (AbstractLogicalOperator)exchg, context);
            exchg.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            OperatorPropertiesUtil.computeSchemaAndPropertiesRecIfNull((AbstractLogicalOperator)exchg, (IOptimizationContext)context);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchg);
            if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
                AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Added partitioning enforcer " + exchg.getPhysicalOperator() + ".\n");
                this.printOp((AbstractLogicalOperator)op);
            }
        }
    }

    private boolean allAreOrderProps(List<ILocalStructuralProperty> cldLocals) {
        for (ILocalStructuralProperty lsp : cldLocals) {
            if (lsp.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) continue;
            return false;
        }
        return !cldLocals.isEmpty();
    }

    private void printOp(AbstractLogicalOperator op) throws AlgebricksException {
        LogicalOperatorPrettyPrintVisitor pvisitor = new LogicalOperatorPrettyPrintVisitor();
        PlanPrettyPrinter.printOperator((AbstractLogicalOperator)op, (AbstractLogicalOperatorPrettyPrintVisitor)pvisitor, (int)0);
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(pvisitor.get().toString());
        }
    }

    private List<OrderColumn> computeOrderColumns(IPhysicalPropertiesVector pv) {
        ArrayList<OrderColumn> ordCols = new ArrayList<OrderColumn>();
        List localProps = pv.getLocalProperties();
        if (localProps == null || localProps.isEmpty()) {
            return new ArrayList<OrderColumn>();
        }
        for (ILocalStructuralProperty p : localProps) {
            if (p.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
                LocalOrderProperty lop = (LocalOrderProperty)p;
                ordCols.addAll(lop.getOrderColumns());
                continue;
            }
            return new ArrayList<OrderColumn>();
        }
        return ordCols;
    }

    private void setNewOp(Mutable<ILogicalOperator> opRef, AbstractLogicalOperator newOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator oldOp = (ILogicalOperator)opRef.getValue();
        opRef.setValue((Object)newOp);
        newOp.getInputs().add(new MutableObject((Object)oldOp));
        newOp.recomputeSchema();
        newOp.computeDeliveredPhysicalProperties(context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newOp);
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Structural properties for " + newOp.getPhysicalOperator() + ": " + newOp.getDeliveredPhysicalProperties() + "\n");
        }
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses((ILogicalOperator)newOp, context);
    }
}

