/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server.utils;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.FormUrlEncodedRequest;

public class HttpUtil {
    private static final Pattern PARENT_DIR = Pattern.compile("/[^./]+/\\.\\./");

    private HttpUtil() {
    }

    public static String getParameter(Map<String, List<String>> parameters, CharSequence name) {
        List<String> parameter = parameters.get(String.valueOf(name));
        if (parameter == null) {
            return null;
        }
        if (parameter.size() == 1) {
            return parameter.get(0);
        }
        StringBuilder aString = new StringBuilder(parameter.get(0));
        for (int i = 1; i < parameter.size(); ++i) {
            aString.append(",").append(parameter.get(i));
        }
        return aString.toString();
    }

    public static IServletRequest toServletRequest(FullHttpRequest request) throws IOException {
        return "application/x-www-form-urlencoded".equals(HttpUtil.getContentTypeOnly((HttpRequest)request)) ? FormUrlEncodedRequest.create(request) : BaseRequest.create(request);
    }

    public static String getContentTypeOnly(IServletRequest request) {
        return HttpUtil.getContentTypeOnly((HttpRequest)request.getHttpRequest());
    }

    public static String getContentTypeOnly(HttpRequest request) {
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType == null ? null : contentType.split(";")[0];
    }

    public static String getRequestBody(IServletRequest request) {
        return request.getHttpRequest().content().toString(StandardCharsets.UTF_8);
    }

    public static void setContentType(IServletResponse response, String type, String charset) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, type + "; charset=" + charset);
    }

    public static void setContentType(IServletResponse response, String type) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, type);
    }

    public static Map<String, String> getRequestHeaders(IServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        request.getHttpRequest().headers().forEach(entry -> headers.put((String)entry.getKey(), (String)entry.getValue()));
        return headers;
    }

    public static String mime(String extension) {
        switch (extension) {
            case ".png": {
                return "image/png";
            }
            case ".eot": {
                return "application/vnd.ms-fontobject";
            }
            case ".svg": {
                return "image/svg+xml\t";
            }
            case ".ttf": {
                return "application/x-font-ttf";
            }
            case ".woff": 
            case ".woff2": {
                return "application/x-font-woff";
            }
            case ".html": {
                return "text/html";
            }
            case ".css": {
                return "text/css";
            }
            case ".txt": {
                return "text/plain";
            }
            case ".ico": {
                return "image/x-icon";
            }
            case ".js": {
                return "application/javascript";
            }
        }
        return null;
    }

    public static String canonicalize(CharSequence requestURL) {
        String clusterURL = "";
        String newClusterURL = requestURL.toString();
        while (!clusterURL.equals(newClusterURL)) {
            clusterURL = newClusterURL;
            newClusterURL = PARENT_DIR.matcher(clusterURL).replaceAll("/");
        }
        return clusterURL;
    }

    public static class ContentType {
        public static final String APPLICATION_ADM = "application/x-adm";
        public static final String APPLICATION_JSON = "application/json";
        public static final String JSON = "json";
        public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String CSV = "text/csv";
        public static final String IMG_PNG = "image/png";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_PLAIN = "text/plain";

        private ContentType() {
        }
    }

    public static class Encoding {
        public static final String UTF8 = "utf-8";

        private Encoding() {
        }
    }
}

