/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hyracks.http.api.IChannelClosedHandler;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.HttpRequestHandler;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpServerHandler<T extends HttpServer>
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final T server;
    protected final int chunkSize;
    protected HttpRequestHandler handler;
    protected IChannelClosedHandler closeHandler;
    protected Future<Void> task;
    protected IServlet servlet;

    public HttpServerHandler(T server, int chunkSize) {
        this.server = server;
        this.chunkSize = chunkSize;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.handler.notifyChannelWritable();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.notifyChannelInactive();
        }
        if (this.closeHandler != null) {
            this.closeHandler.channelClosed((HttpServer)this.server, this.servlet, this.task);
        }
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        FullHttpRequest request = (FullHttpRequest)msg;
        this.handler = null;
        this.task = null;
        this.closeHandler = null;
        try {
            this.servlet = ((HttpServer)this.server).getServlet(request);
            if (this.servlet == null) {
                this.handleServletNotFound(ctx, request);
            } else {
                this.submit(ctx, this.servlet, request);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure Submitting HTTP Request", (Throwable)e);
            this.respond(ctx, request.protocolVersion(), new HttpResponseStatus(500, e.getMessage()));
        }
    }

    protected void respond(ChannelHandlerContext ctx, HttpVersion httpVersion, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(httpVersion, status);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void submit(ChannelHandlerContext ctx, IServlet servlet, FullHttpRequest request) throws IOException {
        IServletRequest servletRequest;
        try {
            servletRequest = HttpUtil.toServletRequest(request);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARN, "Failure Decoding Request", (Throwable)e);
            this.respond(ctx, request.protocolVersion(), HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.handler = new HttpRequestHandler(ctx, servlet, servletRequest, this.chunkSize);
        this.submit(servlet);
    }

    private void submit(IServlet servlet) throws IOException {
        try {
            this.task = ((HttpServer)this.server).getExecutor(this.handler).submit(this.handler);
            this.closeHandler = servlet.getChannelClosedHandler((HttpServer)this.server);
        }
        catch (RejectedExecutionException e) {
            LOGGER.log(Level.WARN, "Request rejected by server executor service. " + e.getMessage());
            this.handler.reject();
        }
    }

    protected void handleServletNotFound(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No servlet for " + request.uri());
        }
        this.respond(ctx, request.protocolVersion(), HttpResponseStatus.NOT_FOUND);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.log(Level.WARN, "Failure handling HTTP Request", cause);
        ctx.close();
    }
}

