/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.ChunkedResponse;
import org.apache.hyracks.http.server.FullResponse;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestHandler
implements Callable<Void> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ChannelHandlerContext ctx;
    private final IServlet servlet;
    private final IServletRequest request;
    private final IServletResponse response;
    private boolean started = false;
    private boolean cancelled = false;

    public HttpRequestHandler(ChannelHandlerContext ctx, IServlet servlet, IServletRequest request, int chunkSize) {
        this.ctx = ctx;
        this.servlet = servlet;
        this.request = request;
        this.response = chunkSize == 0 ? new FullResponse(ctx, request.getHttpRequest()) : new ChunkedResponse(ctx, request.getHttpRequest(), chunkSize);
        request.getHttpRequest().retain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        HttpRequestHandler httpRequestHandler = this;
        synchronized (httpRequestHandler) {
            if (this.cancelled) {
                LOGGER.warn("Request cancelled before it is started");
                return null;
            }
            this.started = true;
        }
        try {
            ChannelFuture lastContentFuture = this.handle();
            if (!HttpUtil.isKeepAlive((HttpMessage)this.request.getHttpRequest())) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Throwable th) {
            LOGGER.log(Level.ERROR, "Failure handling HTTP Request", th);
            this.ctx.close();
        }
        finally {
            this.request.getHttpRequest().release();
        }
        return null;
    }

    private ChannelFuture handle() throws IOException {
        try {
            this.servlet.handle(this.request, this.response);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure during handling of an IServletRequest", (Throwable)e);
            this.response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            this.response.close();
        }
        return this.response.lastContentFuture();
    }

    public void notifyChannelWritable() {
        this.response.notifyChannelWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChannelInactive() {
        HttpRequestHandler httpRequestHandler = this;
        synchronized (httpRequestHandler) {
            if (!this.started) {
                this.cancelled = true;
            }
        }
        if (this.cancelled) {
            this.response.cancel();
            this.request.getHttpRequest().release();
        } else {
            this.response.notifyChannelInactive();
        }
    }

    public void reject() throws IOException {
        try {
            this.response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
            this.response.close();
        }
        finally {
            this.request.getHttpRequest().release();
        }
    }

    public IServlet getServlet() {
        return this.servlet;
    }

    public IServletRequest getRequest() {
        return this.request;
    }
}

