/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.util.HashMap;
import java.util.List;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.runtime.operators.LSMIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexBulkLoadOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;

public class LSMIndexBulkLoadOperatorNodePushable
extends IndexBulkLoadOperatorNodePushable {
    protected final LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage usage;
    protected final IIndexDataflowHelper primaryIndexHelper;
    protected final IDatasetLifecycleManager datasetManager;
    protected final int datasetId;
    protected final int partition;
    protected ILSMIndex primaryIndex;

    public LSMIndexBulkLoadOperatorNodePushable(IIndexDataflowHelperFactory indexDataflowHelperFactory, IIndexDataflowHelperFactory priamryIndexDataflowHelperFactory, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, RecordDescriptor recDesc, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage usage, int datasetId) throws HyracksDataException {
        super(indexDataflowHelperFactory, ctx, partition, fieldPermutation, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, recDesc);
        this.primaryIndexHelper = priamryIndexDataflowHelperFactory != null ? priamryIndexDataflowHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition) : null;
        this.usage = usage;
        this.datasetId = datasetId;
        this.partition = partition;
        INcApplicationContext ncCtx = (INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext();
        this.datasetManager = ncCtx.getDatasetLifecycleManager();
    }

    protected void initializeBulkLoader() throws HyracksDataException {
        ILSMIndex targetIndex = (ILSMIndex)this.index;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("FlushedComponentId", LSMComponentId.DEFAULT_COMPONENT_ID);
        if (this.usage.equals((Object)LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD)) {
            this.bulkLoader = targetIndex.createBulkLoader(this.fillFactor, this.verifyInput, this.numElementsHint, this.checkIfEmptyIndex, parameters);
        } else {
            this.primaryIndexHelper.open();
            this.primaryIndex = (ILSMIndex)this.primaryIndexHelper.getIndexInstance();
            List primaryComponents = this.primaryIndex.getDiskComponents();
            if (!primaryComponents.isEmpty()) {
                ILSMComponentId bulkloadId = LSMComponentIdUtils.union((ILSMComponentId)((ILSMDiskComponent)primaryComponents.get(0)).getId(), (ILSMComponentId)((ILSMDiskComponent)primaryComponents.get(primaryComponents.size() - 1)).getId());
                parameters.put("FlushedComponentId", bulkloadId);
            } else {
                parameters.put("FlushedComponentId", LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID);
            }
            this.bulkLoader = targetIndex.createBulkLoader(this.fillFactor, this.verifyInput, this.numElementsHint, this.checkIfEmptyIndex, parameters);
        }
    }

    public void close() throws HyracksDataException {
        try {
            super.close();
        }
        finally {
            if (this.primaryIndex != null) {
                this.primaryIndexHelper.close();
            }
        }
    }
}

