/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.exceptions;

import org.apache.asterix.om.types.EnumDeserializer;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    static String toExpectedTypeString(byte ... expectedTypeTags) {
        StringBuilder expectedTypes = new StringBuilder();
        int numCandidateTypes = expectedTypeTags.length;
        for (int index = 0; index < numCandidateTypes; ++index) {
            if (index > 0) {
                if (index == numCandidateTypes - 1) {
                    expectedTypes.append(" or ");
                } else {
                    expectedTypes.append(", ");
                }
            }
            expectedTypes.append(EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(expectedTypeTags[index]));
        }
        return expectedTypes.toString();
    }

    static String indexToPosition(int index) {
        int i = index + 1;
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        switch (i % 10) {
            case 1: {
                return i + "st";
            }
            case 2: {
                return i + "nd";
            }
            case 3: {
                return i + "rd";
            }
        }
        return i + "th";
    }
}

