/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.om.base.temporal.DateTimeFormatUtils;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class PrintDateDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new PrintDateDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr0 = new VoidPointable();
                    private IPointable argPtr1 = new VoidPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private StringBuilder sbder;
                    private final UTF8StringWriter utf8Writer;
                    private final DateTimeFormatUtils util;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.sbder = new StringBuilder();
                        this.utf8Writer = new UTF8StringWriter();
                        this.util = DateTimeFormatUtils.getInstance();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        try {
                            if (bytes0[offset0] != ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                throw new TypeMismatchException(PrintDateDescriptor.this.sourceLoc, PrintDateDescriptor.this.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG);
                            }
                            if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                throw new TypeMismatchException(PrintDateDescriptor.this.sourceLoc, PrintDateDescriptor.this.getIdentifier(), (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            long chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                            int formatLength = UTF8StringUtil.getUTFLength((byte[])bytes1, (int)(offset1 + 1));
                            int offset = UTF8StringUtil.getNumBytesToStoreLength((int)formatLength);
                            this.sbder.delete(0, this.sbder.length());
                            this.util.printDateTime(chronon, 0, bytes1, offset1 + 1 + offset, formatLength, (Appendable)this.sbder, DateTimeFormatUtils.DateTimeParseMode.DATE_ONLY);
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.utf8Writer.writeUTF8((CharSequence)this.sbder, this.out);
                        }
                        catch (IOException ex) {
                            throw HyracksDataException.create((Throwable)ex);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.PRINT_DATE;
    }
}

