/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.functions.temporal.IntervalBinDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.temporal.IntervalBinDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnderflowException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class IntervalBinDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable argPtr0 = new VoidPointable();
    private final IPointable argPtr1 = new VoidPointable();
    private final IPointable argPtr2 = new VoidPointable();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private final AMutableInterval aInterval;
    private final ISerializerDeserializer<AInterval> intervalSerde;
    private final GregorianCalendarSystem GREG_CAL;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ IntervalBinDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    IntervalBinDescriptor$_EvaluatorGen(IntervalBinDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval0 = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.eval1 = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.eval2 = this.this$1.val$args[2].createScalarEvaluator(this.val$ctx);
        this.aInterval = new AMutableInterval(0L, 0L, -1);
        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
        this.GREG_CAL = GregorianCalendarSystem.getInstance();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        long binEndChronon;
        long binStartChronon;
        long binIndex;
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.argPtr0);
        if (this.typeChecker.isMissing(this.argPtr0, result)) {
            return;
        }
        this.eval1.evaluate(tuple, this.argPtr1);
        if (this.typeChecker.isMissing(this.argPtr1, result)) {
            return;
        }
        this.eval2.evaluate(tuple, this.argPtr2);
        if (this.typeChecker.isMissing(this.argPtr2, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes0 = this.argPtr0.getByteArray();
        int offset0 = this.argPtr0.getStartOffset();
        ATypeTag type0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
        long chrononToBin = 0L;
        switch (type0) {
            case DATE: {
                chrononToBin = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                break;
            }
            case TIME: {
                chrononToBin = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                break;
            }
            case DATETIME: {
                chrononToBin = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                break;
            }
            default: {
                throw new TypeMismatchException(IntervalBinDescriptor$_Gen.access$000(this.this$1.this$0), this.this$1.this$0.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
        }
        byte[] bytes1 = this.argPtr1.getByteArray();
        int offset1 = this.argPtr1.getStartOffset();
        ATypeTag type1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
        if (type0 != type1) {
            throw new IncompatibleTypeException(IntervalBinDescriptor$_Gen.access$100(this.this$1.this$0), this.this$1.this$0.getIdentifier(), bytes0[offset0], bytes1[offset1]);
        }
        long chrononToStart = 0L;
        switch (type1) {
            case DATE: {
                chrononToStart = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                break;
            }
            case TIME: {
                chrononToStart = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                break;
            }
            case DATETIME: {
                chrononToStart = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                break;
            }
            default: {
                throw new TypeMismatchException(IntervalBinDescriptor$_Gen.access$200(this.this$1.this$0), this.this$1.this$0.getIdentifier(), (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
        }
        byte[] bytes2 = this.argPtr2.getByteArray();
        int offset2 = this.argPtr2.getStartOffset();
        ATypeTag type2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes2[offset2]);
        int yearMonth = 0;
        long dayTime = 0L;
        switch (type2) {
            case YEARMONTHDURATION: {
                yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes2, (int)(offset2 + 1));
                int yearStart = this.GREG_CAL.getYear(chrononToStart);
                int monthStart = this.GREG_CAL.getMonthOfYear(chrononToStart, yearStart);
                int yearToBin = this.GREG_CAL.getYear(chrononToBin);
                int monthToBin = this.GREG_CAL.getMonthOfYear(chrononToBin, yearToBin);
                int totalMonths = (yearToBin - yearStart) * 12 + (monthToBin - monthStart);
                binIndex = totalMonths / yearMonth + (totalMonths < 0 && totalMonths % yearMonth != 0 ? -1 : 0);
                if (binIndex > Integer.MAX_VALUE) {
                    throw new OverflowException(IntervalBinDescriptor$_Gen.access$300(this.this$1.this$0), this.this$1.this$0.getIdentifier());
                }
                if (binIndex >= Integer.MIN_VALUE) break;
                throw new UnderflowException(IntervalBinDescriptor$_Gen.access$400(this.this$1.this$0), this.this$1.this$0.getIdentifier());
            }
            case DAYTIMEDURATION: {
                dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes2, (int)(offset2 + 1));
                long totalChronon = chrononToBin - chrononToStart;
                binIndex = totalChronon / dayTime + (long)(totalChronon < 0L && totalChronon % dayTime != 0L ? -1 : 0);
                break;
            }
            default: {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier().getName(), (Integer)2, bytes2[offset2], ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG);
            }
        }
        switch (type0) {
            case DATE: {
                binStartChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * (int)binIndex), (long)(dayTime * binIndex), (boolean)false);
                binEndChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * ((int)binIndex + 1)), (long)(dayTime * (binIndex + 1L)), (boolean)false);
                binStartChronon = binStartChronon / 86400000L + (long)(binStartChronon < 0L && binStartChronon % 86400000L != 0L ? -1 : 0);
                binEndChronon = binEndChronon / 86400000L + (long)(binEndChronon < 0L && binEndChronon % 86400000L != 0L ? -1 : 0);
                break;
            }
            case TIME: {
                if (yearMonth != 0) {
                    throw new InvalidDataFormatException(IntervalBinDescriptor$_Gen.access$500(this.this$1.this$0), this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                }
                binStartChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * (int)binIndex), (long)(dayTime * binIndex), (boolean)true);
                binEndChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * ((int)binIndex + 1)), (long)(dayTime * (binIndex + 1L)), (boolean)true);
                break;
            }
            case DATETIME: {
                binStartChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * (int)binIndex), (long)(dayTime * binIndex), (boolean)false);
                binEndChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * ((int)binIndex + 1)), (long)(dayTime * (binIndex + 1L)), (boolean)false);
                break;
            }
            default: {
                throw new TypeMismatchException(IntervalBinDescriptor$_Gen.access$600(this.this$1.this$0), this.this$1.this$0.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
        }
        this.aInterval.setValue(binStartChronon, binEndChronon, type0.serialize());
        this.intervalSerde.serialize((Object)this.aInterval, this.out);
        result.set((IValueReference)this.resultStorage);
    }
}

