/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.comparisons.ComparisonHelper;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordReplaceEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    private final IPointable inputRecordPointable = new VoidPointable();
    private final IPointable oldValuePointable = new VoidPointable();
    private final IPointable newValuePointable = new VoidPointable();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput resultOutput = this.resultStorage.getDataOutput();
    private final RecordBuilder outRecordBuilder = new RecordBuilder();
    private final VoidPointable existingValuePtr = new VoidPointable();
    private final VoidPointable oldValuePtr = new VoidPointable();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private final ARecordVisitablePointable openRecordPointable;
    private final CastTypeEvaluator inputRecordCaster;
    private final CastTypeEvaluator newValueRecordCaster;
    private final SourceLocation sourceLoc;
    private final ComparisonHelper comparisonHelper;
    private final TypeChecker typeChecker;

    RecordReplaceEvaluator$_EvaluatorGen(SourceLocation sourceLoc, IScalarEvaluator eval0, IScalarEvaluator eval1, IScalarEvaluator eval2, IAType[] argTypes) {
        this.sourceLoc = sourceLoc;
        this.eval0 = eval0;
        this.eval1 = eval1;
        this.eval2 = eval2;
        this.openRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.inputRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, argTypes[0], eval0);
        this.newValueRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, argTypes[2], eval2);
        this.comparisonHelper = new ComparisonHelper(sourceLoc);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputRecordPointable);
        if (this.typeChecker.isMissing(this.inputRecordPointable, result)) {
            return;
        }
        this.eval1.evaluate(tuple, this.oldValuePointable);
        if (this.typeChecker.isMissing(this.oldValuePointable, result)) {
            return;
        }
        this.eval2.evaluate(tuple, this.newValuePointable);
        if (this.typeChecker.isMissing(this.newValuePointable, result)) {
            return;
        }
        if (this.containsMissing(this.inputRecordPointable, this.oldValuePointable, this.newValuePointable)) {
            this.writeTypeTag(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        ATypeTag inputObjectType = PointableHelper.getTypeTag((IValueReference)this.inputRecordPointable);
        ATypeTag oldValueType = PointableHelper.getTypeTag((IValueReference)this.oldValuePointable);
        if (inputObjectType != ATypeTag.OBJECT || oldValueType == ATypeTag.NULL) {
            this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        if (oldValueType.isDerivedType()) {
            throw new TypeMismatchException(this.sourceLoc, BuiltinFunctions.RECORD_REPLACE, (Integer)1, oldValueType.serialize(), "primitive");
        }
        this.inputRecordCaster.evaluate(tuple, this.inputRecordPointable);
        if (this.typeChecker.isMissing(this.inputRecordPointable, result)) {
            return;
        }
        ATypeTag newValueType = PointableHelper.getTypeTag((IValueReference)this.newValuePointable);
        if (newValueType.isDerivedType()) {
            this.newValueRecordCaster.evaluate(tuple, this.newValuePointable);
            if (this.typeChecker.isMissing(this.newValuePointable, result)) {
                return;
            }
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        this.resultStorage.reset();
        this.buildOutputRecord(oldValueType);
        result.set((IValueReference)this.resultStorage);
    }

    private void buildOutputRecord(ATypeTag oldValueTypeTag) throws HyracksDataException {
        this.openRecordPointable.set((IValueReference)this.inputRecordPointable);
        this.outRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.outRecordBuilder.init();
        List fieldNames = this.openRecordPointable.getFieldNames();
        List fieldValues = this.openRecordPointable.getFieldValues();
        int fieldCount = fieldNames.size();
        for (int i = 0; i < fieldCount; ++i) {
            IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(i);
            IVisitablePointable fieldValue = (IVisitablePointable)fieldValues.get(i);
            ATypeTag existingValueTypeTag = PointableHelper.getTypeTag((IValueReference)fieldValue);
            if (this.isEqual(existingValueTypeTag, (IPointable)fieldValue, oldValueTypeTag, this.oldValuePointable)) {
                this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)this.newValuePointable);
                continue;
            }
            this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
        this.outRecordBuilder.write(this.resultOutput, true);
    }

    private boolean containsMissing(IPointable ... pointables) {
        for (int i = 0; i < pointables.length; ++i) {
            if (PointableHelper.getTypeTag((IValueReference)pointables[i]) != ATypeTag.MISSING) continue;
            return true;
        }
        return false;
    }

    private void writeTypeTag(byte typeTag) throws HyracksDataException {
        try {
            this.resultOutput.writeByte(typeTag);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean isEqual(ATypeTag typeTag1, IPointable value1, ATypeTag typeTag2, IPointable value2) throws HyracksDataException {
        if (!ATypeHierarchy.isCompatible((ATypeTag)typeTag1, (ATypeTag)typeTag2)) {
            return false;
        }
        RecordReplaceEvaluator$_EvaluatorGen.setValuePointer(value1, (IPointable)this.existingValuePtr);
        RecordReplaceEvaluator$_EvaluatorGen.setValuePointer(value2, (IPointable)this.oldValuePtr);
        return this.comparisonHelper.compare(typeTag1, typeTag2, (IPointable)this.existingValuePtr, (IPointable)this.oldValuePtr) == 0;
    }

    private static void setValuePointer(IPointable src, IPointable value) {
        value.set(src.getByteArray(), src.getStartOffset() + 1, src.getLength() - 1);
    }
}

