/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.BinaryHashMap;
import org.apache.asterix.runtime.evaluators.functions.records.RecordConcatEvalFactory;
import org.apache.asterix.runtime.evaluators.functions.records.RecordConcatEvalFactory$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.records.RecordConcatEvalFactory$_InnerGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.BinaryEntry;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

final class RecordConcatEvalFactory$_EvaluatorGen
implements IScalarEvaluator {
    private static final int TABLE_FRAME_SIZE = 32768;
    private static final int TABLE_SIZE = 100;
    private final IScalarEvaluator[] argEvals;
    private final IPointable[] argPointables;
    private final ARecordVisitablePointable[] argRecordPointables;
    private final ARecordVisitablePointable openRecordPointable;
    private final BitSet castRequired;
    private ACastVisitor castVisitor;
    private Triple<IVisitablePointable, IAType, Boolean> castVisitorArg;
    private final RecordBuilder outRecordBuilder;
    private final ArrayBackedValueStorage resultStorage;
    private final DataOutput resultOutput;
    private final BinaryHashMap fieldMap;
    private final BinaryEntry keyEntry;
    private final BinaryEntry valEntry;
    final /* synthetic */ RecordConcatEvalFactory$_EvaluatorFactoryGen this$0;
    private final TypeChecker typeChecker;

    private RecordConcatEvalFactory$_EvaluatorGen(RecordConcatEvalFactory$_EvaluatorFactoryGen recordConcatEvalFactory$_EvaluatorFactoryGen, IScalarEvaluator[] argEvals) {
        this.this$0 = recordConcatEvalFactory$_EvaluatorFactoryGen;
        this.argEvals = argEvals;
        this.argPointables = new IPointable[RecordConcatEvalFactory$_EvaluatorFactoryGen.access$100(recordConcatEvalFactory$_EvaluatorFactoryGen).length];
        this.argRecordPointables = new ARecordVisitablePointable[RecordConcatEvalFactory$_EvaluatorFactoryGen.access$100(recordConcatEvalFactory$_EvaluatorFactoryGen).length];
        this.openRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.resultStorage = new ArrayBackedValueStorage();
        this.resultOutput = this.resultStorage.getDataOutput();
        this.outRecordBuilder = new RecordBuilder();
        this.outRecordBuilder.reset(this.openRecordPointable.getInputRecordType());
        this.fieldMap = new BinaryHashMap(100, 32768, this.outRecordBuilder.getFieldNameHashFunction(), this.outRecordBuilder.getFieldNameHashFunction(), this.outRecordBuilder.getFieldNameComparator());
        this.keyEntry = new BinaryEntry();
        this.valEntry = new BinaryEntry();
        this.valEntry.set(new byte[0], 0, 0);
        this.castRequired = new BitSet();
        for (int i = 0; i < RecordConcatEvalFactory$_EvaluatorFactoryGen.access$100(recordConcatEvalFactory$_EvaluatorFactoryGen).length; ++i) {
            this.argPointables[i] = new VoidPointable();
            ARecordType argType = RecordConcatEvalFactory$_EvaluatorFactoryGen.access$200(recordConcatEvalFactory$_EvaluatorFactoryGen)[i];
            if (argType == null) continue;
            this.argRecordPointables[i] = new ARecordVisitablePointable(argType);
            if (!this.hasDerivedType(argType.getFieldTypes())) continue;
            this.castRequired.set(i);
            if (this.castVisitor != null) continue;
            this.castVisitor = new ACastVisitor();
            this.castVisitorArg = new Triple((Object)this.openRecordPointable, (Object)this.openRecordPointable.getInputRecordType(), (Object)Boolean.FALSE);
        }
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        if (this.validateArgs(tuple)) {
            this.processArgs();
        }
        result.set((IValueReference)this.resultStorage);
    }

    private boolean validateArgs(IFrameTupleReference tuple) throws HyracksDataException {
        if (RecordConcatEvalFactory$_EvaluatorFactoryGen.access$100(this.this$0).length == 0) {
            this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            return false;
        }
        boolean returnMissing = false;
        boolean returnNull = false;
        for (int i = 0; i < this.argEvals.length; ++i) {
            IPointable argPtr = this.argPointables[i];
            this.argEvals[i].evaluate(tuple, argPtr);
            byte[] data = argPtr.getByteArray();
            int offset = argPtr.getStartOffset();
            byte typeTag = data[offset];
            if (typeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                returnMissing = true;
                if (RecordConcatEvalFactory$_EvaluatorFactoryGen.access$300(this.this$0)) continue;
                break;
            }
            if (typeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                returnNull = true;
                continue;
            }
            if (typeTag == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) continue;
            if (RecordConcatEvalFactory$_EvaluatorFactoryGen.access$300(this.this$0)) {
                throw new TypeMismatchException(RecordConcatEvalFactory$_EvaluatorFactoryGen.access$400(this.this$0), BuiltinFunctions.RECORD_CONCAT, (Integer)i, typeTag, ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
            }
            returnNull = true;
        }
        if (returnMissing) {
            this.writeTypeTag(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            return false;
        }
        if (returnNull) {
            this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            return false;
        }
        return true;
    }

    private void processArgs() throws HyracksDataException {
        this.outRecordBuilder.init();
        this.fieldMap.clear();
        for (int i = this.argEvals.length - 1; i >= 0; --i) {
            try {
                this.appendRecord(this.argPointables[i], this.argRecordPointables[i], this.castRequired.get(i));
                continue;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.outRecordBuilder.write(this.resultOutput, true);
    }

    private void appendRecord(IPointable recordPtr, ARecordVisitablePointable argVisitablePointable, boolean argCastRequired) throws IOException {
        ARecordVisitablePointable recordPointable;
        if (argVisitablePointable != null) {
            argVisitablePointable.set((IValueReference)recordPtr);
            if (argCastRequired) {
                argVisitablePointable.accept((IVisitablePointableVisitor)this.castVisitor, this.castVisitorArg);
                recordPointable = this.openRecordPointable;
            } else {
                recordPointable = argVisitablePointable;
            }
        } else {
            this.openRecordPointable.set((IValueReference)recordPtr);
            recordPointable = this.openRecordPointable;
        }
        List fieldNames = recordPointable.getFieldNames();
        List fieldValues = recordPointable.getFieldValues();
        int fieldCount = fieldNames.size();
        for (int i = 0; i < fieldCount; ++i) {
            IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(i);
            if (!this.canAppendField(fieldName.getByteArray(), fieldName.getStartOffset() + 1, fieldName.getLength() - 1)) continue;
            this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValues.get(i));
        }
    }

    private boolean canAppendField(byte[] buf, int offset, int length) throws HyracksDataException {
        this.keyEntry.set(buf, offset, length);
        return this.fieldMap.put(this.keyEntry, this.valEntry) == null;
    }

    private boolean hasDerivedType(IAType[] types) {
        for (IAType type : types) {
            if (!type.getTypeTag().isDerivedType()) continue;
            return true;
        }
        return false;
    }

    private void writeTypeTag(byte typeTag) throws HyracksDataException {
        try {
            this.resultOutput.writeByte(typeTag);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /* synthetic */ RecordConcatEvalFactory$_EvaluatorGen(RecordConcatEvalFactory x0, IScalarEvaluator[] x1, RecordConcatEvalFactory$_InnerGen x2) {
        this((RecordConcatEvalFactory$_EvaluatorFactoryGen)((Object)x0), x1);
        this.typeChecker = new TypeChecker();
    }
}

