/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator$_EvaluatorGen;
import org.apache.asterix.runtime.evaluators.functions.binary.ParseBinaryDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.binary.ParseBinaryDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.bytes.Base64Parser;
import org.apache.hyracks.util.bytes.HexParser;

class ParseBinaryDescriptor$_EvaluatorGen
extends AbstractBinaryScalarEvaluator$_EvaluatorGen {
    private ISerializerDeserializer<ABinary> binarySerde;
    private AMutableBinary aBinary;
    private final UTF8StringPointable stringPointable;
    private final UTF8StringPointable formatPointable;
    private final HexParser hexParser;
    private final Base64Parser base64Parser;
    final /* synthetic */ ParseBinaryDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ParseBinaryDescriptor$_EvaluatorGen(ParseBinaryDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext context, IScalarEvaluatorFactory[] evaluatorFactories, SourceLocation sourceLoc) {
        this.this$1 = this$1;
        super(context, evaluatorFactories, sourceLoc);
        this.binarySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
        this.aBinary = new AMutableBinary(new byte[0], 0, 0);
        this.stringPointable = new UTF8StringPointable();
        this.formatPointable = new UTF8StringPointable();
        this.hexParser = new HexParser();
        this.base64Parser = new Base64Parser();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.evaluators[0].evaluate(tuple, this.pointables[0]);
        if (this.typeChecker.isMissing(this.pointables[0], result)) {
            return;
        }
        this.evaluators[1].evaluate(tuple, this.pointables[1]);
        if (this.typeChecker.isMissing(this.pointables[1], result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        ATypeTag binaryTag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[0].getByteArray()[this.pointables[0].getStartOffset()]];
        ATypeTag formatTag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[1].getByteArray()[this.pointables[1].getStartOffset()]];
        this.checkTypeMachingThrowsIfNot(this.this$1.this$0.getIdentifier().getName(), ParseBinaryDescriptor$_Gen.EXPECTED_INPUT_TAGS, binaryTag, formatTag);
        this.stringPointable.set(this.pointables[0].getByteArray(), this.pointables[0].getStartOffset() + 1, this.pointables[0].getLength());
        this.formatPointable.set(this.pointables[1].getByteArray(), this.pointables[1].getStartOffset() + 1, this.pointables[1].getLength());
        if (ParseBinaryDescriptor$_Gen.access$100().ignoreCaseCompareTo(this.formatPointable) == 0) {
            this.hexParser.generateByteArrayFromHexString(this.stringPointable.getByteArray(), this.stringPointable.getCharStartOffset(), this.stringPointable.getUTF8Length());
            this.aBinary.setValue(this.hexParser.getByteArray(), 0, this.hexParser.getLength());
        } else if (ParseBinaryDescriptor$_Gen.access$200().ignoreCaseCompareTo(this.formatPointable) == 0) {
            this.base64Parser.generatePureByteArrayFromBase64String(this.stringPointable.getByteArray(), this.stringPointable.getCharStartOffset(), this.stringPointable.getUTF8Length());
            this.aBinary.setValue(this.base64Parser.getByteArray(), 0, this.base64Parser.getLength());
        } else {
            throw new UnsupportedItemTypeException(this.sourceLoc, this.this$1.this$0.getIdentifier(), formatTag.serialize());
        }
        this.binarySerde.serialize((Object)this.aBinary, this.dataOutput);
        result.set((IValueReference)this.resultStorage);
    }
}

