/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator$_EvaluatorGen;
import org.apache.asterix.runtime.evaluators.functions.binary.BinaryConcatDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

class BinaryConcatDescriptor$_EvaluatorGen
extends AbstractBinaryScalarEvaluator$_EvaluatorGen {
    private final ListAccessor listAccessor;
    private final byte[] metaBuffer;
    private ISerializerDeserializer<ANull> nullSerde;
    private ISerializerDeserializer<AMissing> missingSerde;
    final /* synthetic */ BinaryConcatDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    BinaryConcatDescriptor$_EvaluatorGen(BinaryConcatDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext context, IScalarEvaluatorFactory[] evaluatorFactories, SourceLocation sourceLoc) {
        this.this$1 = this$1;
        super(context, evaluatorFactories, sourceLoc);
        this.listAccessor = new ListAccessor();
        this.metaBuffer = new byte[5];
        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
        this.missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.evaluators[0].evaluate(tuple, this.pointables[0]);
        if (this.typeChecker.isMissing(this.pointables[0], result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] data = this.pointables[0].getByteArray();
        byte typeTag = data[offset = this.pointables[0].getStartOffset()];
        if (typeTag != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG && typeTag != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
            throw new TypeMismatchException(this.sourceLoc, this.this$1.this$0.getIdentifier(), (Integer)0, typeTag, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
        }
        try {
            this.listAccessor.reset(data, offset);
            int concatLength = 0;
            boolean itemIsNull = false;
            for (int i = 0; i < this.listAccessor.size(); ++i) {
                int itemOffset = this.listAccessor.getItemOffset(i);
                ATypeTag itemType = this.listAccessor.getItemType(itemOffset);
                if (itemType != ATypeTag.BINARY) {
                    if (itemType == ATypeTag.NULL) {
                        itemIsNull = true;
                        continue;
                    }
                    if (itemType == ATypeTag.MISSING) {
                        this.missingSerde.serialize((Object)AMissing.MISSING, this.dataOutput);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    throw new UnsupportedItemTypeException(this.sourceLoc, this.this$1.this$0.getIdentifier(), itemType.serialize());
                }
                concatLength += ByteArrayPointable.getContentLength((byte[])data, (int)itemOffset);
            }
            if (itemIsNull) {
                this.nullSerde.serialize((Object)ANull.NULL, this.dataOutput);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            this.dataOutput.writeByte(ATypeTag.SERIALIZED_BINARY_TYPE_TAG);
            int metaLen = VarLenIntEncoderDecoder.encode((int)concatLength, (byte[])this.metaBuffer, (int)0);
            this.dataOutput.write(this.metaBuffer, 0, metaLen);
            for (int i = 0; i < this.listAccessor.size(); ++i) {
                int itemOffset = this.listAccessor.getItemOffset(i);
                int length = ByteArrayPointable.getContentLength((byte[])data, (int)itemOffset);
                this.dataOutput.write(data, itemOffset + ByteArrayPointable.getNumberBytesToStoreMeta((int)length), length);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

