/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractUnaryStringStringEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;

public class StringReverseDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringReverseDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new AbstractUnaryStringStringEval(ctx, args[0], StringReverseDescriptor.this.getIdentifier(), StringReverseDescriptor.this.sourceLoc){

                    @Override
                    void process(UTF8StringPointable inputString, IPointable resultPointable) throws IOException {
                        UTF8StringPointable.reverse((UTF8StringPointable)inputString, (UTF8StringBuilder)this.resultBuilder, (GrowableArray)this.resultArray);
                        resultPointable.set(this.resultArray.getByteArray(), 0, this.resultArray.getLength());
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_REVERSE;
    }
}

