/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class NumericRoundHalfToEvenDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NumericRoundHalfToEvenDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_ROUND_HALF_TO_EVEN;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutableDouble aDouble;
                    private AMutableFloat aFloat;
                    private AMutableInt64 aInt64;
                    private AMutableInt32 aInt32;
                    private AMutableInt16 aInt16;
                    private AMutableInt8 aInt8;
                    private ISerializerDeserializer serde;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aDouble = new AMutableDouble(0.0);
                        this.aFloat = new AMutableFloat(0.0f);
                        this.aInt64 = new AMutableInt64(0L);
                        this.aInt32 = new AMutableInt32(0);
                        this.aInt16 = new AMutableInt16(0);
                        this.aInt8 = new AMutableInt8(0);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval.evaluate(tuple, this.argPtr);
                        byte[] data = this.argPtr.getByteArray();
                        int offset = this.argPtr.getStartOffset();
                        if (data[offset] == ATypeTag.SERIALIZED_INT8_TYPE_TAG) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
                            byte val = AInt8SerializerDeserializer.getByte((byte[])data, (int)(offset + 1));
                            this.aInt8.setValue(val);
                            this.serde.serialize((Object)this.aInt8, this.out);
                        } else if (data[offset] == ATypeTag.SERIALIZED_INT16_TYPE_TAG) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
                            short val = AInt16SerializerDeserializer.getShort((byte[])data, (int)(offset + 1));
                            this.aInt16.setValue(val);
                            this.serde.serialize((Object)this.aInt16, this.out);
                        } else if (data[offset] == ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                            int val = AInt32SerializerDeserializer.getInt((byte[])data, (int)(offset + 1));
                            this.aInt32.setValue(val);
                            this.serde.serialize((Object)this.aInt32, this.out);
                        } else if (data[offset] == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                            long val = AInt64SerializerDeserializer.getLong((byte[])data, (int)(offset + 1));
                            this.aInt64.setValue(val);
                            this.serde.serialize((Object)this.aInt64, this.out);
                        } else if (data[offset] == ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                            float val = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
                            this.aFloat.setValue((float)Math.rint(val));
                            this.serde.serialize((Object)this.aFloat, this.out);
                        } else if (data[offset] == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                            double val = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
                            this.aDouble.setValue(Math.rint(val));
                            this.serde.serialize((Object)this.aDouble, this.out);
                        } else {
                            throw new TypeMismatchException(NumericRoundHalfToEvenDescriptor.this.sourceLoc, NumericRoundHalfToEvenDescriptor.this.getIdentifier(), (Integer)0, data[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

