/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.CodePointToStringDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.CodePointToStringDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class CodePointToStringDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IScalarEvaluatorFactory listEvalFactory;
    private IPointable inputArgList;
    private IScalarEvaluator evalList;
    private final byte[] currentUTF8;
    private final byte[] tempStoreForLength;
    private final byte stringTypeTag;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ CodePointToStringDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    CodePointToStringDescriptor$_EvaluatorGen(CodePointToStringDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.listEvalFactory = this.this$1.val$args[0];
        this.inputArgList = new VoidPointable();
        this.evalList = this.listEvalFactory.createScalarEvaluator(this.val$ctx);
        this.currentUTF8 = new byte[6];
        this.tempStoreForLength = new byte[5];
        this.stringTypeTag = ATypeTag.SERIALIZED_STRING_TYPE_TAG;
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            int codePoint;
            int itemOffset;
            int i;
            int size;
            int offset;
            this.resultStorage.reset();
            this.evalList.evaluate(tuple, this.inputArgList);
            if (this.typeChecker.isMissing(this.inputArgList, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serOrderedList = this.inputArgList.getByteArray();
            if (ATypeTag.VALUE_TYPE_MAPPING[serOrderedList[offset = this.inputArgList.getStartOffset()]] != ATypeTag.ARRAY) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier().getName(), (Integer)0, serOrderedList[offset], new byte[0]);
            }
            switch (ATypeTag.VALUE_TYPE_MAPPING[serOrderedList[offset + 1]]) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: 
                case ANY: {
                    size = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serOrderedList, (int)offset);
                    break;
                }
                default: {
                    throw new UnsupportedTypeException(CodePointToStringDescriptor$_Gen.access$000(this.this$1.this$0), this.this$1.this$0.getIdentifier(), serOrderedList[offset]);
                }
            }
            int utf_8_len = 0;
            for (i = 0; i < size; ++i) {
                itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)i);
                codePoint = 0;
                codePoint = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)this.this$1.this$0.getIdentifier().getName(), (int)0, (byte[])serOrderedList, (int)itemOffset, (int)(offset + 1));
                utf_8_len += UTF8StringUtil.codePointToUTF8((int)codePoint, (byte[])this.currentUTF8);
            }
            this.out.writeByte(this.stringTypeTag);
            UTF8StringUtil.writeUTF8Length((int)utf_8_len, (byte[])this.tempStoreForLength, (DataOutput)this.out);
            for (i = 0; i < size; ++i) {
                itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)i);
                codePoint = 0;
                codePoint = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)this.this$1.this$0.getIdentifier().getName(), (int)0, (byte[])serOrderedList, (int)itemOffset, (int)(offset + 1));
                utf_8_len = UTF8StringUtil.codePointToUTF8((int)codePoint, (byte[])this.currentUTF8);
                for (int j = 0; j < utf_8_len; ++j) {
                    this.out.writeByte(this.currentUTF8[j]);
                }
            }
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

