/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class CastTypeEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    private IScalarEvaluator argEvaluator;
    private final IPointable argPointable = new VoidPointable();
    private final PointableAllocator allocator = new PointableAllocator();
    private IVisitablePointable inputPointable;
    private IVisitablePointable resultPointable;
    private final ACastVisitor castVisitor = this.createCastVisitor();
    private final Triple<IVisitablePointable, IAType, Boolean> arg = new Triple(null, null, null);
    private final TypeChecker typeChecker;

    public CastTypeEvaluator$_EvaluatorGen() {
        this.typeChecker = new TypeChecker();
    }

    public CastTypeEvaluator$_EvaluatorGen(IAType reqType, IAType inputType, IScalarEvaluator argEvaluator) {
        this.resetAndAllocate(reqType, inputType, argEvaluator);
        this.typeChecker = new TypeChecker();
    }

    public void resetAndAllocate(IAType reqType, IAType inputType, IScalarEvaluator argEvaluator) {
        this.argEvaluator = argEvaluator;
        this.inputPointable = this.allocatePointable(inputType, reqType);
        this.resultPointable = this.allocatePointable(reqType, inputType);
        this.arg.first = this.resultPointable;
        this.arg.second = reqType;
        this.arg.third = Boolean.FALSE;
    }

    protected ACastVisitor createCastVisitor() {
        return new ACastVisitor();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.argEvaluator.evaluate(tuple, this.argPointable);
        if (this.typeChecker.isMissing(this.argPointable, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        this.inputPointable.set((IValueReference)this.argPointable);
        this.cast(result);
    }

    protected void cast(IPointable result) throws HyracksDataException {
        this.inputPointable.accept((IVisitablePointableVisitor)this.castVisitor, this.arg);
        result.set((IValueReference)this.resultPointable);
    }

    protected void cast(IPointable argPointable, IPointable result) throws HyracksDataException {
        this.inputPointable.set((IValueReference)argPointable);
        this.cast(result);
    }

    private IVisitablePointable allocatePointable(IAType typeForPointable, IAType typeForOtherSide) {
        if (!typeForPointable.equals(BuiltinType.ANY)) {
            return this.allocator.allocateFieldValue(typeForPointable);
        }
        return this.allocatePointableForAny(typeForOtherSide);
    }

    private IVisitablePointable allocatePointableForAny(IAType type) {
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case OBJECT: {
                return this.allocator.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            }
            case ARRAY: {
                return this.allocator.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
            }
            case MULTISET: {
                return this.allocator.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE);
            }
        }
        return this.allocator.allocateFieldValue(null);
    }

    public void deallocatePointables() {
        this.allocator.reset();
    }
}

