/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayReplaceDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType inputListType;
    private IAType newValueType;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayReplaceDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENTS_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_REPLACE;
    }

    public void setImmutableStates(Object ... states) {
        this.inputListType = (IAType)states[0];
        this.newValueType = (IAType)states[2];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new ArrayReplaceEval(args, ctx);
            }
        };
    }

    public class ArrayReplaceEval
    implements IScalarEvaluator {
        private final IScalarEvaluator listEval;
        private final IScalarEvaluator targetValEval;
        private final IScalarEvaluator newValEval;
        private IScalarEvaluator maxEval;
        private final IPointable list;
        private final IPointable tempList;
        private final IPointable target;
        private final IPointable newVal;
        private final IPointable tempVal;
        private TaggedValuePointable maxArg;
        private final AbstractPointable item;
        private final ListAccessor listAccessor;
        private final IBinaryComparator comp;
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final CastTypeEvaluator caster;
        private IAsterixListBuilder orderedListBuilder;
        private IAsterixListBuilder unorderedListBuilder;

        public ArrayReplaceEval(IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
            this.listEval = args[0].createScalarEvaluator(ctx);
            this.targetValEval = args[1].createScalarEvaluator(ctx);
            this.newValEval = args[2].createScalarEvaluator(ctx);
            if (args.length == 4) {
                this.maxEval = args[3].createScalarEvaluator(ctx);
                this.maxArg = new TaggedValuePointable();
            }
            this.list = new VoidPointable();
            this.tempList = new VoidPointable();
            this.target = new VoidPointable();
            this.newVal = new VoidPointable();
            this.tempVal = new VoidPointable();
            this.item = new VoidPointable();
            this.listAccessor = new ListAccessor();
            this.caster = new CastTypeEvaluator();
            this.orderedListBuilder = null;
            this.unorderedListBuilder = null;
            this.comp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.storage.reset();
            this.listEval.evaluate(tuple, this.tempList);
            this.targetValEval.evaluate(tuple, this.target);
            this.newValEval.evaluate(tuple, this.tempVal);
            ATypeTag listType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.tempList.getByteArray()[this.tempList.getStartOffset()]);
            ATypeTag targetTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.target.getByteArray()[this.target.getStartOffset()]);
            ATypeTag newValTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.tempVal.getByteArray()[this.tempVal.getStartOffset()]);
            if (listType == ATypeTag.MISSING || targetTag == ATypeTag.MISSING || newValTag == ATypeTag.MISSING) {
                PointableHelper.setMissing(result);
                return;
            }
            double maxDouble = -1.0;
            String name = ArrayReplaceDescriptor.this.getIdentifier().getName();
            if (this.maxEval != null) {
                this.maxEval.evaluate(tuple, (IPointable)this.maxArg);
                ATypeTag maxTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.maxArg.getTag());
                if (maxTag == ATypeTag.MISSING) {
                    PointableHelper.setMissing(result);
                    return;
                }
                if (!ATypeHierarchy.isCompatible((ATypeTag)maxTag, (ATypeTag)ATypeTag.DOUBLE)) {
                    PointableHelper.setNull(result);
                    return;
                }
                maxDouble = ATypeHierarchy.getDoubleValue((String)name, (int)3, (byte[])this.maxArg.getByteArray(), (int)this.maxArg.getStartOffset());
            }
            if (!listType.isListType() || Math.floor(maxDouble) < maxDouble || targetTag == ATypeTag.NULL || Double.isInfinite(maxDouble) || Double.isNaN(maxDouble)) {
                PointableHelper.setNull(result);
                return;
            }
            if (targetTag.isDerivedType()) {
                throw new RuntimeDataException(36, ArrayReplaceDescriptor.this.sourceLoc, new Serializable[0]);
            }
            try {
                IAsterixListBuilder listBuilder;
                IAType defaultOpenType = DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)listType);
                this.caster.resetAndAllocate(defaultOpenType, ArrayReplaceDescriptor.this.inputListType, this.listEval);
                this.caster.cast(this.tempList, this.list);
                defaultOpenType = DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)newValTag);
                if (defaultOpenType != null) {
                    this.caster.resetAndAllocate(defaultOpenType, ArrayReplaceDescriptor.this.newValueType, this.newValEval);
                    this.caster.cast(this.tempVal, this.newVal);
                } else {
                    this.newVal.set((IValueReference)this.tempVal);
                }
                int max = (int)maxDouble;
                if (listType == ATypeTag.ARRAY) {
                    if (this.orderedListBuilder == null) {
                        this.orderedListBuilder = new OrderedListBuilder();
                    }
                    listBuilder = this.orderedListBuilder;
                } else {
                    if (this.unorderedListBuilder == null) {
                        this.unorderedListBuilder = new UnorderedListBuilder();
                    }
                    listBuilder = this.unorderedListBuilder;
                }
                listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)listType));
                this.listAccessor.reset(this.list.getByteArray(), this.list.getStartOffset());
                int counter = 0;
                byte[] targetBytes = this.target.getByteArray();
                int offset = this.target.getStartOffset();
                int length = this.target.getLength();
                for (int i = 0; i < this.listAccessor.size(); ++i) {
                    this.listAccessor.getOrWriteItem(i, (IPointable)this.item, this.storage);
                    if (counter != max && this.comp.compare(this.item.getByteArray(), this.item.getStartOffset(), this.item.getLength(), targetBytes, offset, length) == 0) {
                        listBuilder.addItem((IValueReference)this.newVal);
                        ++counter;
                        continue;
                    }
                    listBuilder.addItem((IValueReference)this.item);
                }
                this.storage.reset();
                listBuilder.write(this.storage.getDataOutput(), true);
                result.set((IValueReference)this.storage);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.caster.deallocatePointables();
            }
        }
    }
}

