/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessEval$_EvaluatorGen;
import org.apache.asterix.runtime.evaluators.functions.ArrayDistinctDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.utils.ArrayFunctionsUtil;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ArrayDistinctDescriptor$_EvaluatorGen
extends AbstractArrayProcessEval$_EvaluatorGen {
    private final SourceLocation sourceLoc;
    private final IBinaryHashFunction binaryHashFunction;
    private final Int2ObjectMap<List<IPointable>> hashes;
    private final IBinaryComparator comp;
    private IPointable item;
    private ArrayBackedValueStorage storage;
    final /* synthetic */ ArrayDistinctDescriptor$_Gen this$0;
    private final TypeChecker typeChecker;

    public ArrayDistinctDescriptor$_EvaluatorGen(ArrayDistinctDescriptor$_Gen this$0, IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx, SourceLocation sourceLoc) throws HyracksDataException {
        this.this$0 = this$0;
        super(args, ctx, ArrayDistinctDescriptor$_Gen.access$100(this$0));
        this.sourceLoc = sourceLoc;
        this.hashes = new Int2ObjectOpenHashMap();
        this.comp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        this.binaryHashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory(null).createBinaryHashFunction();
        this.typeChecker = new TypeChecker();
    }

    @Override
    protected void processList(ListAccessor listAccessor, IAsterixListBuilder listBuilder) throws IOException {
        boolean nullMissingWasAdded = false;
        this.hashes.clear();
        this.item = this.pointableAllocator.allocateEmpty();
        this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
        for (int i = 0; i < listAccessor.size(); ++i) {
            boolean itemInStorage = listAccessor.getOrWriteItem(i, this.item, this.storage);
            if (((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.item.getByteArray()[this.item.getStartOffset()])).isDerivedType()) {
                throw new RuntimeDataException(36, this.sourceLoc, new Serializable[0]);
            }
            if (this.isNullOrMissing(this.item)) {
                if (nullMissingWasAdded) continue;
                listBuilder.addItem((IValueReference)this.item);
                nullMissingWasAdded = true;
                continue;
            }
            int hash = this.binaryHashFunction.hash(this.item.getByteArray(), this.item.getStartOffset(), this.item.getLength());
            this.hashes.get(hash);
            List sameHashes = (List)this.hashes.get(hash);
            if (sameHashes == null) {
                sameHashes = (List)this.arrayListAllocator.allocate(null);
                sameHashes.clear();
                this.addItem(this.item, listBuilder, itemInStorage, sameHashes);
                this.hashes.put(hash, (Object)sameHashes);
                this.item = this.pointableAllocator.allocateEmpty();
                continue;
            }
            if (ArrayFunctionsUtil.findItem((IValueReference)this.item, sameHashes, this.comp) != null) continue;
            this.addItem(this.item, listBuilder, itemInStorage, sameHashes);
            this.item = this.pointableAllocator.allocateEmpty();
        }
    }

    private boolean isNullOrMissing(IPointable item) {
        byte tag = item.getByteArray()[item.getStartOffset()];
        return tag == ATypeTag.SERIALIZED_NULL_TYPE_TAG || tag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG;
    }

    private void addItem(IPointable item, IAsterixListBuilder listBuilder, boolean itemInStorage, List<IPointable> sameHashes) throws HyracksDataException {
        sameHashes.add(item);
        listBuilder.addItem((IValueReference)item);
        if (itemInStorage) {
            this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
        }
    }
}

