/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractUnaryNumericFunctionEval$_EvaluatorGen
implements IScalarEvaluator {
    protected final IPointable argPtr = new VoidPointable();
    protected final AMutableDouble aDouble = new AMutableDouble(0.0);
    protected final AMutableFloat aFloat = new AMutableFloat(0.0f);
    protected final AMutableInt64 aInt64 = new AMutableInt64(0L);
    protected final AMutableInt32 aInt32 = new AMutableInt32(0);
    protected final AMutableInt16 aInt16 = new AMutableInt16(0);
    protected final AMutableInt8 aInt8 = new AMutableInt8(0);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput dataOutput = this.resultStorage.getDataOutput();
    private final IScalarEvaluator argEval;
    protected ISerializerDeserializer int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
    protected ISerializerDeserializer int16Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
    protected ISerializerDeserializer int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    protected ISerializerDeserializer int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected ISerializerDeserializer floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
    protected ISerializerDeserializer doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private final FunctionIdentifier funcID;
    private final SourceLocation sourceLoc;
    private final TypeChecker typeChecker;

    public AbstractUnaryNumericFunctionEval$_EvaluatorGen(IHyracksTaskContext context, IScalarEvaluatorFactory argEvalFactory, FunctionIdentifier funcID, SourceLocation sourceLoc) throws HyracksDataException {
        this.argEval = argEvalFactory.createScalarEvaluator(context);
        this.funcID = funcID;
        this.sourceLoc = sourceLoc;
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.argEval.evaluate(tuple, this.argPtr);
        if (this.typeChecker.isMissing(this.argPtr, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] data = this.argPtr.getByteArray();
        if (data[offset = this.argPtr.getStartOffset()] == ATypeTag.SERIALIZED_INT8_TYPE_TAG) {
            byte val = AInt8SerializerDeserializer.getByte((byte[])data, (int)(offset + 1));
            this.processInt8(val, result);
        } else if (data[offset] == ATypeTag.SERIALIZED_INT16_TYPE_TAG) {
            short val = AInt16SerializerDeserializer.getShort((byte[])data, (int)(offset + 1));
            this.processInt16(val, result);
        } else if (data[offset] == ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
            int val = AInt32SerializerDeserializer.getInt((byte[])data, (int)(offset + 1));
            this.processInt32(val, result);
        } else if (data[offset] == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
            long val = AInt64SerializerDeserializer.getLong((byte[])data, (int)(offset + 1));
            this.processInt64(val, result);
        } else if (data[offset] == ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
            float val = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
            this.processFloat(val, result);
        } else if (data[offset] == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
            double val = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
            this.processDouble(val, result);
        } else {
            throw new TypeMismatchException(this.sourceLoc, this.funcID, (Integer)0, data[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
        }
    }

    protected abstract void processInt8(byte var1, IPointable var2) throws HyracksDataException;

    protected abstract void processInt16(short var1, IPointable var2) throws HyracksDataException;

    protected abstract void processInt32(int var1, IPointable var2) throws HyracksDataException;

    protected abstract void processInt64(long var1, IPointable var3) throws HyracksDataException;

    protected abstract void processFloat(float var1, IPointable var2) throws HyracksDataException;

    protected abstract void processDouble(double var1, IPointable var3) throws HyracksDataException;

    protected void serialize(IAObject result, ISerializerDeserializer serde, IPointable resultPointable) throws HyracksDataException {
        try {
            serde.serialize((Object)result, this.dataOutput);
            resultPointable.set((IValueReference)this.resultStorage);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

