/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnderflowException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractNumericArithmeticEval
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 527445160961348706L;

    protected abstract boolean evaluateInteger(long var1, long var3, AMutableInt64 var5) throws HyracksDataException;

    protected abstract boolean evaluateDouble(double var1, double var3, AMutableDouble var5) throws HyracksDataException;

    protected abstract boolean evaluateTimeDurationArithmetic(long var1, int var3, long var4, boolean var6, AMutableInt64 var7) throws HyracksDataException;

    protected abstract boolean evaluateTimeInstanceArithmetic(long var1, long var3, AMutableInt64 var5) throws HyracksDataException;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr0 = new VoidPointable();
                    private final IPointable argPtr1 = new VoidPointable();
                    private final IScalarEvaluator evalLeft;
                    private final IScalarEvaluator evalRight;
                    private final double[] operandsFloating;
                    private final long[] operandsInteger;
                    private final AMutableFloat aFloat;
                    private final AMutableDouble aDouble;
                    private final AMutableInt64 aInt64;
                    private final AMutableInt32 aInt32;
                    private final AMutableInt16 aInt16;
                    private final AMutableInt8 aInt8;
                    private final AMutableDuration aDuration;
                    private final AMutableDate aDate;
                    private final AMutableTime aTime;
                    private final AMutableDateTime aDatetime;
                    private final ISerializerDeserializer int8Serde;
                    private final ISerializerDeserializer int16Serde;
                    private final ISerializerDeserializer int32Serde;
                    private final ISerializerDeserializer int64Serde;
                    private final ISerializerDeserializer floatSerde;
                    private final ISerializerDeserializer doubleSerde;
                    private final ISerializerDeserializer dateSerde;
                    private final ISerializerDeserializer timeSerde;
                    private final ISerializerDeserializer dateTimeSerde;
                    private final ISerializerDeserializer durationSerde;
                    private final ISerializerDeserializer nullSerde;
                    {
                        this.evalLeft = args[0].createScalarEvaluator(ctx);
                        this.evalRight = args[1].createScalarEvaluator(ctx);
                        this.operandsFloating = new double[args.length];
                        this.operandsInteger = new long[args.length];
                        this.aFloat = new AMutableFloat(0.0f);
                        this.aDouble = new AMutableDouble(0.0);
                        this.aInt64 = new AMutableInt64(0L);
                        this.aInt32 = new AMutableInt32(0);
                        this.aInt16 = new AMutableInt16(0);
                        this.aInt8 = new AMutableInt8(0);
                        this.aDuration = new AMutableDuration(0, 0L);
                        this.aDate = new AMutableDate(0);
                        this.aTime = new AMutableTime(0);
                        this.aDatetime = new AMutableDateTime(0L);
                        this.int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
                        this.int16Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
                        this.int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                        this.floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                        this.doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                        this.dateSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                        this.timeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
                        this.dateTimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                        this.durationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADURATION);
                        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.evalLeft.evaluate(tuple, this.argPtr0);
                        this.evalRight.evaluate(tuple, this.argPtr1);
                        this.resultStorage.reset();
                        ATypeTag argTypeMax = null;
                        for (int i = 0; i < 2; ++i) {
                            ATypeTag currentType;
                            IPointable argPtr = i == 0 ? this.argPtr0 : this.argPtr1;
                            byte[] bytes = argPtr.getByteArray();
                            int offset = argPtr.getStartOffset();
                            ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
                            switch (typeTag) {
                                case TINYINT: {
                                    currentType = ATypeTag.TINYINT;
                                    this.operandsInteger[i] = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case SMALLINT: {
                                    currentType = ATypeTag.SMALLINT;
                                    this.operandsInteger[i] = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case INTEGER: {
                                    currentType = ATypeTag.INTEGER;
                                    this.operandsInteger[i] = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case BIGINT: {
                                    currentType = ATypeTag.BIGINT;
                                    this.operandsInteger[i] = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case FLOAT: {
                                    currentType = ATypeTag.FLOAT;
                                    this.operandsFloating[i] = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1));
                                    break;
                                }
                                case DOUBLE: {
                                    currentType = ATypeTag.DOUBLE;
                                    this.operandsFloating[i] = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1));
                                    break;
                                }
                                case DATE: 
                                case TIME: 
                                case DATETIME: 
                                case DURATION: 
                                case YEARMONTHDURATION: 
                                case DAYTIMEDURATION: {
                                    this.evaluateTemporalArithmeticOperation(typeTag);
                                    result.set((IValueReference)this.resultStorage);
                                    return;
                                }
                                default: {
                                    throw new TypeMismatchException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), (Integer)i, bytes[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG, ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG, ATypeTag.SERIALIZED_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG);
                                }
                            }
                            if (i != 0 && currentType.ordinal() <= argTypeMax.ordinal()) continue;
                            argTypeMax = currentType;
                        }
                        ATypeTag resultType = AbstractNumericArithmeticEval.this.getNumericResultType(argTypeMax);
                        switch (resultType) {
                            case TINYINT: {
                                if (AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1], this.aInt64)) {
                                    long lres = this.aInt64.getLongValue();
                                    if (lres > 127L) {
                                        throw new OverflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    if (lres < -128L) {
                                        throw new UnderflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    this.aInt8.setValue((byte)lres);
                                    this.int8Serde.serialize((Object)this.aInt8, this.out);
                                    break;
                                }
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                break;
                            }
                            case SMALLINT: {
                                if (AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1], this.aInt64)) {
                                    long lres = this.aInt64.getLongValue();
                                    if (lres > 32767L) {
                                        throw new OverflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    if (lres < -32768L) {
                                        throw new UnderflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    this.aInt16.setValue((short)lres);
                                    this.int16Serde.serialize((Object)this.aInt16, this.out);
                                    break;
                                }
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                break;
                            }
                            case INTEGER: {
                                if (AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1], this.aInt64)) {
                                    long lres = this.aInt64.getLongValue();
                                    if (lres > Integer.MAX_VALUE) {
                                        throw new OverflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    if (lres < Integer.MIN_VALUE) {
                                        throw new UnderflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    this.aInt32.setValue((int)lres);
                                    this.int32Serde.serialize((Object)this.aInt32, this.out);
                                    break;
                                }
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                break;
                            }
                            case BIGINT: {
                                if (AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1], this.aInt64)) {
                                    this.int64Serde.serialize((Object)this.aInt64, this.out);
                                    break;
                                }
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                break;
                            }
                            case FLOAT: {
                                if (AbstractNumericArithmeticEval.this.evaluateDouble(this.operandsFloating[0], this.operandsFloating[1], this.aDouble)) {
                                    double dres = this.aDouble.getDoubleValue();
                                    if (dres > 3.4028234663852886E38) {
                                        throw new OverflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    if (dres < -3.4028234663852886E38) {
                                        throw new UnderflowException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier());
                                    }
                                    this.aFloat.setValue((float)dres);
                                    this.floatSerde.serialize((Object)this.aFloat, this.out);
                                    break;
                                }
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                break;
                            }
                            case DOUBLE: {
                                if (AbstractNumericArithmeticEval.this.evaluateDouble(this.operandsFloating[0], this.operandsFloating[1], this.aDouble)) {
                                    this.doubleSerde.serialize((Object)this.aDouble, this.out);
                                    break;
                                }
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                            }
                        }
                        result.set((IValueReference)this.resultStorage);
                    }

                    private void evaluateTemporalArithmeticOperation(ATypeTag leftType) throws HyracksDataException {
                        block46: {
                            block47: {
                                int offset0;
                                byte[] bytes0;
                                ATypeTag rightType;
                                int offset1;
                                byte[] bytes1;
                                block45: {
                                    bytes1 = this.argPtr1.getByteArray();
                                    offset1 = this.argPtr1.getStartOffset();
                                    rightType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                                    bytes0 = this.argPtr0.getByteArray();
                                    offset0 = this.argPtr0.getStartOffset();
                                    if (rightType != leftType) break block45;
                                    long leftChronon = 0L;
                                    long rightChronon = 0L;
                                    long dayTime = 0L;
                                    int yearMonth = 0;
                                    boolean yearMonthIsNull = false;
                                    boolean dayTimeIsNull = false;
                                    switch (leftType) {
                                        case DATE: {
                                            leftChronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                                            rightChronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                            break;
                                        }
                                        case TIME: {
                                            leftChronon = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                            rightChronon = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                            break;
                                        }
                                        case DATETIME: {
                                            leftChronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                            rightChronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                            break;
                                        }
                                        case YEARMONTHDURATION: {
                                            if (AbstractNumericArithmeticEval.this.evaluateTimeInstanceArithmetic(AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes0, (int)(offset0 + 1)), AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1)), this.aInt64)) {
                                                yearMonth = (int)this.aInt64.getLongValue();
                                                break;
                                            }
                                            yearMonthIsNull = true;
                                            break;
                                        }
                                        case DAYTIMEDURATION: {
                                            leftChronon = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes0, (int)(offset0 + 1));
                                            rightChronon = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                            break;
                                        }
                                        default: {
                                            throw new UnsupportedTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes1[offset1]);
                                        }
                                    }
                                    if (AbstractNumericArithmeticEval.this.evaluateTimeInstanceArithmetic(leftChronon, rightChronon, this.aInt64)) {
                                        dayTime = this.aInt64.getLongValue();
                                    } else {
                                        dayTimeIsNull = true;
                                    }
                                    if (yearMonthIsNull || dayTimeIsNull) {
                                        this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                    } else {
                                        this.aDuration.setValue(yearMonth, dayTime);
                                        this.durationSerde.serialize((Object)this.aDuration, this.out);
                                    }
                                    break block46;
                                }
                                long chronon = 0L;
                                long dayTime = 0L;
                                int yearMonth = 0;
                                ATypeTag resultType = null;
                                ISerializerDeserializer serde = null;
                                boolean isTimeOnly = false;
                                block7 : switch (leftType) {
                                    case TIME: {
                                        serde = this.timeSerde;
                                        chronon = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                        isTimeOnly = true;
                                        resultType = ATypeTag.TIME;
                                        switch (rightType) {
                                            case DAYTIMEDURATION: {
                                                dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                            case DURATION: {
                                                dayTime = ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                                yearMonth = ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                        }
                                        throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                    }
                                    case DATE: {
                                        serde = this.dateSerde;
                                        resultType = ATypeTag.DATE;
                                        chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                                    }
                                    case DATETIME: {
                                        if (leftType == ATypeTag.DATETIME) {
                                            serde = this.dateTimeSerde;
                                            resultType = ATypeTag.DATETIME;
                                            chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                        }
                                        switch (rightType) {
                                            case DURATION: {
                                                yearMonth = ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                                                dayTime = ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                            case YEARMONTHDURATION: {
                                                yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                            case DAYTIMEDURATION: {
                                                dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                        }
                                        throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                    }
                                    case YEARMONTHDURATION: {
                                        yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes0, (int)(offset0 + 1));
                                        switch (rightType) {
                                            case DATETIME: {
                                                serde = this.dateTimeSerde;
                                                resultType = ATypeTag.DATETIME;
                                                chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                            case DATE: {
                                                serde = this.dateSerde;
                                                resultType = ATypeTag.DATE;
                                                chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                                break block7;
                                            }
                                        }
                                        throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                    }
                                    case DURATION: {
                                        yearMonth = ADurationSerializerDeserializer.getYearMonth((byte[])bytes0, (int)(offset0 + 1));
                                        dayTime = ADurationSerializerDeserializer.getDayTime((byte[])bytes0, (int)(offset0 + 1));
                                    }
                                    case DAYTIMEDURATION: {
                                        if (leftType == ATypeTag.DAYTIMEDURATION) {
                                            dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes0, (int)(offset0 + 1));
                                        }
                                        switch (rightType) {
                                            case DATETIME: {
                                                serde = this.dateTimeSerde;
                                                resultType = ATypeTag.DATETIME;
                                                chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                                break block7;
                                            }
                                            case DATE: {
                                                serde = this.dateSerde;
                                                resultType = ATypeTag.DATE;
                                                chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                                break block7;
                                            }
                                            case TIME: {
                                                if (yearMonth != 0) break;
                                                serde = this.timeSerde;
                                                resultType = ATypeTag.TIME;
                                                chronon = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                                isTimeOnly = true;
                                                break block7;
                                            }
                                        }
                                        throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                    }
                                    default: {
                                        throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                    }
                                }
                                if (!AbstractNumericArithmeticEval.this.evaluateTimeDurationArithmetic(chronon, yearMonth, dayTime, isTimeOnly, this.aInt64)) break block47;
                                chronon = this.aInt64.getLongValue();
                                switch (resultType) {
                                    case DATE: {
                                        chronon = chronon < 0L && chronon % 86400000L != 0L ? chronon / 86400000L - 1L : (chronon /= 86400000L);
                                        this.aDate.setValue((int)chronon);
                                        serde.serialize((Object)this.aDate, this.out);
                                        break block46;
                                    }
                                    case TIME: {
                                        this.aTime.setValue((int)chronon);
                                        serde.serialize((Object)this.aTime, this.out);
                                        break block46;
                                    }
                                    case DATETIME: {
                                        this.aDatetime.setValue(chronon);
                                        serde.serialize((Object)this.aDatetime, this.out);
                                        break block46;
                                    }
                                    default: {
                                        throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.sourceLoc, AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                    }
                                }
                            }
                            this.nullSerde.serialize((Object)ANull.NULL, this.out);
                        }
                    }
                };
            }
        };
    }

    protected ATypeTag getNumericResultType(ATypeTag argTypeMax) {
        return argTypeMax;
    }
}

