/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import java.io.DataOutput;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.comparisons.ComparisonHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ConstantEvalFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractComparisonEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final TaggedValuePointable argLeft = TaggedValuePointable.FACTORY.createPointable();
    protected final TaggedValuePointable argRight = TaggedValuePointable.FACTORY.createPointable();
    protected final IPointable outLeft = VoidPointable.FACTORY.createPointable();
    protected final IPointable outRight = VoidPointable.FACTORY.createPointable();
    protected final IScalarEvaluator evalLeft;
    protected final IScalarEvaluator evalRight;
    protected final SourceLocation sourceLoc;
    private final ComparisonHelper ch;
    private Number leftValue;
    private Number rightValue;
    private final TypeChecker typeChecker;

    public AbstractComparisonEvaluator$_EvaluatorGen(IScalarEvaluatorFactory evalLeftFactory, IScalarEvaluatorFactory evalRightFactory, IHyracksTaskContext ctx, SourceLocation sourceLoc) throws HyracksDataException {
        this.evalLeft = evalLeftFactory.createScalarEvaluator(ctx);
        this.evalRight = evalRightFactory.createScalarEvaluator(ctx);
        this.sourceLoc = sourceLoc;
        this.ch = new ComparisonHelper(sourceLoc);
        this.leftValue = this.getValueOfConstantEval(evalLeftFactory);
        this.rightValue = this.getValueOfConstantEval(evalRightFactory);
        this.typeChecker = new TypeChecker();
    }

    private Number getValueOfConstantEval(IScalarEvaluatorFactory factory) throws HyracksDataException {
        if (factory instanceof ConstantEvalFactory) {
            return this.ch.getNumberValue(((ConstantEvalFactory)factory).getValue());
        }
        return null;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.evalLeft.evaluate(tuple, (IPointable)this.argLeft);
        if (this.typeChecker.isMissing((IPointable)this.argLeft, result)) {
            return;
        }
        this.evalRight.evaluate(tuple, (IPointable)this.argRight);
        if (this.typeChecker.isMissing((IPointable)this.argRight, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        this.argLeft.getValue(this.outLeft);
        this.argRight.getValue(this.outRight);
        this.evaluateImpl(result);
    }

    protected abstract void evaluateImpl(IPointable var1) throws HyracksDataException;

    boolean comparabilityCheck() {
        ATypeTag typeTag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag());
        ATypeTag typeTag2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argRight.getTag());
        return ATypeHierarchy.isCompatible((ATypeTag)typeTag1, (ATypeTag)typeTag2);
    }

    int compare() throws HyracksDataException {
        ATypeTag leftTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag());
        ATypeTag rightTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argRight.getTag());
        return this.ch.compare(leftTypeTag, rightTypeTag, this.outLeft, this.outRight, this.leftValue, this.rightValue);
    }
}

