/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.accessors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ALineSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class LineRectanglePolygonAccessor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final FunctionIdentifier FID = BuiltinFunctions.GET_POINTS_LINE_RECTANGLE_POLYGON_ACCESSOR;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new LineRectanglePolygonAccessor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr = new VoidPointable();
                    private final IScalarEvaluator eval;
                    private final OrderedListBuilder listBuilder;
                    private final ArrayBackedValueStorage inputVal;
                    private final AOrderedListType pointListType;
                    private final AMutablePoint aPoint;
                    private final ISerializerDeserializer<APoint> pointSerde;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.listBuilder = new OrderedListBuilder();
                        this.inputVal = new ArrayBackedValueStorage();
                        this.pointListType = new AOrderedListType((IAType)BuiltinType.APOINT, null);
                        this.aPoint = new AMutablePoint(0.0, 0.0);
                        this.pointSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.APOINT);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block7: {
                            this.eval.evaluate(tuple, this.argPtr);
                            byte[] bytes = this.argPtr.getByteArray();
                            int startOffset = this.argPtr.getStartOffset();
                            this.resultStorage.reset();
                            try {
                                if (bytes[startOffset] == ATypeTag.SERIALIZED_LINE_TYPE_TAG) {
                                    this.listBuilder.reset((AbstractCollectionType)this.pointListType);
                                    this.inputVal.reset();
                                    double startX = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                                    double startY = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                    this.aPoint.setValue(startX, startY);
                                    this.pointSerde.serialize((Object)this.aPoint, this.inputVal.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.inputVal);
                                    this.inputVal.reset();
                                    double endX = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                                    double endY = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                    this.aPoint.setValue(endX, endY);
                                    this.pointSerde.serialize((Object)this.aPoint, this.inputVal.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.inputVal);
                                    this.listBuilder.write(this.out, true);
                                    break block7;
                                }
                                if (bytes[startOffset] == ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG) {
                                    this.listBuilder.reset((AbstractCollectionType)this.pointListType);
                                    this.inputVal.reset();
                                    double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                                    double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                                    this.aPoint.setValue(x1, y1);
                                    this.pointSerde.serialize((Object)this.aPoint, this.inputVal.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.inputVal);
                                    this.inputVal.reset();
                                    double x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                                    double y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                                    this.aPoint.setValue(x2, y2);
                                    this.pointSerde.serialize((Object)this.aPoint, this.inputVal.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.inputVal);
                                    this.listBuilder.write(this.out, true);
                                    break block7;
                                }
                                if (bytes[startOffset] == ATypeTag.SERIALIZED_POLYGON_TYPE_TAG) {
                                    int numOfPoints = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(startOffset + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                                    if (numOfPoints < 3) {
                                        throw new InvalidDataFormatException(LineRectanglePolygonAccessor.this.sourceLoc, LineRectanglePolygonAccessor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                                    }
                                    this.listBuilder.reset((AbstractCollectionType)this.pointListType);
                                    for (int i = 0; i < numOfPoints; ++i) {
                                        this.inputVal.reset();
                                        double x = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.X)));
                                        double y = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.Y)));
                                        this.aPoint.setValue(x, y);
                                        this.pointSerde.serialize((Object)this.aPoint, this.inputVal.getDataOutput());
                                        this.listBuilder.addItem((IValueReference)this.inputVal);
                                    }
                                    this.listBuilder.write(this.out, true);
                                    break block7;
                                }
                                throw new TypeMismatchException(LineRectanglePolygonAccessor.this.sourceLoc, LineRectanglePolygonAccessor.this.getIdentifier(), (Integer)0, bytes[startOffset], ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw HyracksDataException.create((Throwable)e);
                            }
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

