/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.collections;

import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ListifyAggregateFunctionEvalFactory
implements IAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory[] args;
    private final AOrderedListType orderedlistType;
    private final SourceLocation sourceLoc;

    public ListifyAggregateFunctionEvalFactory(IScalarEvaluatorFactory[] args, AOrderedListType type, SourceLocation sourceLoc) {
        this.args = args;
        this.orderedlistType = type;
        this.sourceLoc = sourceLoc;
    }

    public IAggregateEvaluator createAggregateEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new AbstractAggregateFunction(this.sourceLoc){
            private IPointable inputVal;
            private IScalarEvaluator eval;
            private ArrayBackedValueStorage resultStorage;
            private OrderedListBuilder builder;
            {
                super(sourceLoc);
                this.inputVal = new VoidPointable();
                this.eval = ListifyAggregateFunctionEvalFactory.this.args[0].createScalarEvaluator(ctx);
                this.resultStorage = new ArrayBackedValueStorage();
                this.builder = new OrderedListBuilder();
            }

            public void init() throws HyracksDataException {
                this.builder.reset((AbstractCollectionType)ListifyAggregateFunctionEvalFactory.this.orderedlistType);
            }

            public void step(IFrameTupleReference tuple) throws HyracksDataException {
                try {
                    this.eval.evaluate(tuple, this.inputVal);
                    this.builder.addItem((IValueReference)this.inputVal);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            public void finish(IPointable result) throws HyracksDataException {
                this.resultStorage.reset();
                try {
                    this.builder.write(this.resultStorage.getDataOutput(), true);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                result.set((IValueReference)this.resultStorage);
            }

            public void finishPartial(IPointable result) throws HyracksDataException {
                this.finish(result);
            }
        };
    }
}

