/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.ipc.api.IIPCEventListener;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPCPerformanceCounters;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.IPCConnectionManager;
import org.apache.hyracks.ipc.impl.Message;
import org.apache.hyracks.ipc.impl.NoOpIPCEventListener;
import org.apache.hyracks.ipc.impl.ReconnectingIPCHandle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPCSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IPCConnectionManager cMgr;
    private final IIPCI ipci;
    private final IPayloadSerializerDeserializer serde;
    private final AtomicLong midFactory;
    private final IPCPerformanceCounters perfCounters;

    public IPCSystem(InetSocketAddress socketAddress, IIPCI ipci, IPayloadSerializerDeserializer serde) throws IOException {
        this.cMgr = new IPCConnectionManager(this, socketAddress);
        this.ipci = ipci;
        this.serde = serde;
        this.midFactory = new AtomicLong();
        this.perfCounters = new IPCPerformanceCounters();
    }

    public InetSocketAddress getSocketAddress() {
        return this.cMgr.getAddress();
    }

    public void start() {
        this.cMgr.start();
    }

    public void stop() {
        this.cMgr.stop();
    }

    public IIPCHandle getHandle(InetSocketAddress remoteAddress, int maxRetries) throws IPCException {
        return this.getHandle(remoteAddress, maxRetries, 0);
    }

    public IIPCHandle getReconnectingHandle(InetSocketAddress remoteAddress) throws IPCException {
        return this.getReconnectingHandle(remoteAddress, 1);
    }

    public IIPCHandle getHandle(InetSocketAddress remoteAddress, int maxRetries, int reconnectAttempts, IIPCEventListener eventListener) throws IPCException {
        if (reconnectAttempts > 0) {
            return new ReconnectingIPCHandle(this, eventListener, remoteAddress, maxRetries, reconnectAttempts);
        }
        try {
            return this.cMgr.getIPCHandle(remoteAddress, maxRetries);
        }
        catch (IOException e) {
            throw new IPCException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IPCException(e);
        }
    }

    IPayloadSerializerDeserializer getSerializerDeserializer() {
        return this.serde;
    }

    long createMessageId() {
        return this.midFactory.incrementAndGet();
    }

    void deliverIncomingMessage(Message message) {
        long mid = message.getMessageId();
        long rmid = message.getRequestMessageId();
        Object payload = null;
        Exception exception = null;
        if (message.getFlag() == 3) {
            exception = (Exception)message.getPayload();
            LOGGER.log(Level.INFO, "Exception in message", (Throwable)exception);
        } else {
            payload = message.getPayload();
        }
        this.ipci.deliverIncomingMessage(message.getIPCHandle(), mid, rmid, payload, exception);
    }

    IPCConnectionManager getConnectionManager() {
        return this.cMgr;
    }

    public IPCPerformanceCounters getPerformanceCounters() {
        return this.perfCounters;
    }

    private IIPCHandle getReconnectingHandle(InetSocketAddress remoteAddress, int reconnectAttempts) throws IPCException {
        return this.getHandle(remoteAddress, 0, reconnectAttempts, NoOpIPCEventListener.INSTANCE);
    }

    private IIPCHandle getHandle(InetSocketAddress remoteAddress, int maxRetries, int reconnectAttempts) throws IPCException {
        return this.getHandle(remoteAddress, maxRetries, reconnectAttempts, NoOpIPCEventListener.INSTANCE);
    }
}

