/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FunctionUtil {
    public static final String IMPORT_PRIVATE_FUNCTIONS = "import-private-functions";

    public static IFunctionInfo getFunctionInfo(FunctionIdentifier fi) {
        return BuiltinFunctions.getAsterixFunctionInfo((FunctionIdentifier)fi);
    }

    public static IFunctionInfo getFunctionInfo(FunctionSignature fs) {
        return FunctionUtil.getFunctionInfo(new FunctionIdentifier(fs.getNamespace(), fs.getName(), fs.getArity()));
    }

    public static List<FunctionDecl> retrieveUsedStoredFunctions(MetadataProvider metadataProvider, Expression expression, List<FunctionSignature> declaredFunctions, List<FunctionDecl> inputFunctionDecls, IFunctionCollector functionCollector, IFunctionParser functionParser, IFunctionNormalizer functionNormalizer) throws CompilationException {
        List<FunctionDecl> functionDecls;
        List<FunctionDecl> list = functionDecls = inputFunctionDecls == null ? new ArrayList<FunctionDecl>() : new ArrayList<FunctionDecl>(inputFunctionDecls);
        if (expression == null) {
            return functionDecls;
        }
        String value = (String)metadataProvider.getConfig().get(IMPORT_PRIVATE_FUNCTIONS);
        boolean includePrivateFunctions = value != null ? Boolean.valueOf(value.toLowerCase()) : false;
        Set<CallExpr> functionCalls = functionCollector.getFunctionCalls(expression);
        for (CallExpr functionCall : functionCalls) {
            FunctionDecl functionDecl;
            Function function;
            FunctionSignature signature = functionCall.getFunctionSignature();
            if (declaredFunctions != null && declaredFunctions.contains(signature)) continue;
            if (signature.getNamespace() == null) {
                signature.setNamespace(metadataProvider.getDefaultDataverseName());
            }
            String namespace = signature.getNamespace();
            try {
                if (!namespace.equals("asterix") && !namespace.equals("algebricks") && metadataProvider.findDataverse(namespace) == null) {
                    throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{"In function call \"" + namespace + "." + signature.getName() + "(...)\", the dataverse \"" + namespace + "\" cannot be found!"});
                }
            }
            catch (AlgebricksException e) {
                throw new CompilationException((Throwable)e);
            }
            try {
                function = FunctionUtil.lookupUserDefinedFunctionDecl(metadataProvider.getMetadataTxnContext(), signature);
            }
            catch (AlgebricksException e) {
                throw new CompilationException((Throwable)e);
            }
            if (function == null) {
                FunctionSignature normalizedSignature;
                FunctionSignature functionSignature = normalizedSignature = functionNormalizer == null ? signature : functionNormalizer.normalizeBuiltinFunctionSignature(signature, functionCall.getSourceLocation());
                if (BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)normalizedSignature, (boolean)includePrivateFunctions)) continue;
                StringBuilder messageBuilder = new StringBuilder();
                if (!functionDecls.isEmpty()) {
                    messageBuilder.append("function " + ((FunctionDecl)functionDecls.get(functionDecls.size() - 1)).getSignature() + " depends upon function " + signature + " which is undefined");
                } else {
                    messageBuilder.append("function " + signature + " is not defined");
                }
                throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{messageBuilder.toString()});
            }
            if (!function.getLanguage().equalsIgnoreCase("AQL") && !function.getLanguage().equalsIgnoreCase("SQLPP") || (functionDecl = functionParser.getFunctionDecl(function)) == null) continue;
            if (functionDecls.contains(functionDecl)) {
                throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{"Recursive invocation " + functionDecls.get(functionDecls.size() - 1).getSignature() + " <==> " + functionDecl.getSignature()});
            }
            functionDecls.add(functionDecl);
            functionDecls = FunctionUtil.retrieveUsedStoredFunctions(metadataProvider, functionDecl.getFuncBody(), declaredFunctions, functionDecls, functionCollector, functionParser, functionNormalizer);
        }
        return functionDecls;
    }

    public static List<List<List<String>>> getFunctionDependencies(IQueryRewriter rewriter, Expression expression, MetadataProvider metadataProvider) throws CompilationException {
        Set<CallExpr> functionCalls = rewriter.getFunctionCalls(expression);
        ArrayList<List<String>> datasourceDependencies = new ArrayList<List<String>>();
        ArrayList<List<String>> functionDependencies = new ArrayList<List<String>>();
        for (CallExpr functionCall : functionCalls) {
            FunctionSignature signature = functionCall.getFunctionSignature();
            FunctionIdentifier fid = new FunctionIdentifier(signature.getNamespace(), signature.getName(), signature.getArity());
            if (fid.equals((Object)BuiltinFunctions.DATASET)) {
                Pair path = DatasetUtil.getDatasetInfo((MetadataProvider)metadataProvider, (String)((LiteralExpr)functionCall.getExprList().get(0)).getValue().getStringValue());
                datasourceDependencies.add(Arrays.asList((String)path.first, (String)path.second));
                continue;
            }
            if (BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)signature, (boolean)false)) continue;
            functionDependencies.add(Arrays.asList(signature.getNamespace(), signature.getName(), Integer.toString(signature.getArity())));
        }
        ArrayList<List<List<String>>> dependencies = new ArrayList<List<List<String>>>();
        dependencies.add(datasourceDependencies);
        dependencies.add(functionDependencies);
        return dependencies;
    }

    private static Function lookupUserDefinedFunctionDecl(MetadataTransactionContext mdTxnCtx, FunctionSignature signature) throws AlgebricksException {
        if (signature.getNamespace() == null) {
            return null;
        }
        return MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
    }

    @FunctionalInterface
    public static interface IFunctionNormalizer {
        public FunctionSignature normalizeBuiltinFunctionSignature(FunctionSignature var1, SourceLocation var2) throws CompilationException;
    }

    @FunctionalInterface
    public static interface IFunctionParser {
        public FunctionDecl getFunctionDecl(Function var1) throws CompilationException;
    }

    @FunctionalInterface
    public static interface IFunctionCollector {
        public Set<CallExpr> getFunctionCalls(Expression var1) throws CompilationException;
    }
}

