/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.util.LangRecordParseUtil;
import org.apache.asterix.object.base.AdmArrayNode;
import org.apache.asterix.object.base.AdmBigIntNode;
import org.apache.asterix.object.base.AdmBooleanNode;
import org.apache.asterix.object.base.AdmDoubleNode;
import org.apache.asterix.object.base.AdmNullNode;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static IAdmNode toNode(Expression expr) throws AlgebricksException {
        switch (expr.getKind()) {
            case LIST_CONSTRUCTOR_EXPRESSION: {
                return ExpressionUtils.toNode((ListConstructor)expr);
            }
            case LITERAL_EXPRESSION: {
                return ExpressionUtils.toNode((LiteralExpr)expr);
            }
            case RECORD_CONSTRUCTOR_EXPRESSION: {
                return ExpressionUtils.toNode((RecordConstructor)expr);
            }
        }
        throw new CompilationException(1057, new Serializable[]{expr.getKind()});
    }

    public static AdmObjectNode toNode(RecordConstructor recordConstructor) throws AlgebricksException {
        AdmObjectNode node = new AdmObjectNode();
        List<FieldBinding> fbList = recordConstructor.getFbList();
        for (int i = 0; i < fbList.size(); ++i) {
            FieldBinding binding = fbList.get(i);
            String key = LangRecordParseUtil.exprToStringLiteral(binding.getLeftExpr()).getStringValue();
            IAdmNode value = ExpressionUtils.toNode(binding.getRightExpr());
            node.set(key, value);
        }
        return node;
    }

    private static IAdmNode toNode(ListConstructor listConstructor) throws AlgebricksException {
        List<Expression> exprList = listConstructor.getExprList();
        AdmArrayNode array = new AdmArrayNode(exprList.size());
        for (int i = 0; i < exprList.size(); ++i) {
            array.add(ExpressionUtils.toNode(exprList.get(i)));
        }
        return array;
    }

    private static IAdmNode toNode(LiteralExpr literalExpr) throws AlgebricksException {
        Literal value = literalExpr.getValue();
        Literal.Type literalType = value.getLiteralType();
        switch (literalType) {
            case DOUBLE: {
                return new AdmDoubleNode(((DoubleLiteral)value).getDoubleValue());
            }
            case FALSE: 
            case TRUE: {
                return AdmBooleanNode.get((Boolean)((Boolean)value.getValue()));
            }
            case LONG: {
                return new AdmBigIntNode(((LongIntegerLiteral)value).getLongValue());
            }
            case NULL: {
                return AdmNullNode.INSTANCE;
            }
            case STRING: {
                return new AdmStringNode(((StringLiteral)value).getValue());
            }
        }
        throw new CompilationException(1058, new Serializable[]{literalType});
    }
}

