/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public class LSMIndexDiskComponentBulkLoader
implements IIndexBulkLoader {
    private final AbstractLSMIndex lsmIndex;
    private final ILSMDiskComponentBulkLoader componentBulkLoader;
    private final ILSMIndexOperationContext opCtx;
    private boolean failed = false;

    public LSMIndexDiskComponentBulkLoader(AbstractLSMIndex lsmIndex, ILSMIndexOperationContext opCtx, float fillFactor, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        this.lsmIndex = lsmIndex;
        this.opCtx = opCtx;
        this.componentBulkLoader = opCtx.getIoOperation().getNewComponent().createBulkLoader(opCtx.getIoOperation(), fillFactor, verifyInput, numElementsHint, false, true, true);
    }

    public ILSMDiskComponent getComponent() {
        return this.opCtx.getIoOperation().getNewComponent();
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        try {
            this.componentBulkLoader.add(tuple);
        }
        catch (Throwable th) {
            this.opCtx.getIoOperation().setFailure(th);
            throw th;
        }
    }

    public void delete(ITupleReference tuple) throws HyracksDataException {
        try {
            this.componentBulkLoader.delete(tuple);
        }
        catch (Throwable th) {
            this.opCtx.getIoOperation().setFailure(th);
            throw th;
        }
    }

    public void end() throws HyracksDataException {
        try {
            this.presistComponentToDisk();
        }
        catch (Throwable th) {
            this.fail(th);
            throw th;
        }
        finally {
            this.lsmIndex.getIOOperationCallback().completed(this.opCtx.getIoOperation());
        }
    }

    public void abort() throws HyracksDataException {
        this.opCtx.getIoOperation().setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
        try {
            try {
                this.componentBulkLoader.abort();
            }
            finally {
                this.lsmIndex.getIOOperationCallback().afterFinalize(this.opCtx.getIoOperation());
            }
        }
        finally {
            this.lsmIndex.getIOOperationCallback().completed(this.opCtx.getIoOperation());
        }
    }

    public void writeFailed(ICachedPage page, Throwable failure) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFailed() {
        return this.opCtx.getIoOperation().hasFailed();
    }

    public Throwable getFailure() {
        return this.opCtx.getIoOperation().getFailure();
    }

    private void presistComponentToDisk() throws HyracksDataException {
        try {
            this.lsmIndex.getIOOperationCallback().afterOperation(this.opCtx.getIoOperation());
            this.componentBulkLoader.end();
        }
        catch (Throwable th) {
            this.fail(th);
            throw th;
        }
        finally {
            this.lsmIndex.getIOOperationCallback().afterFinalize(this.opCtx.getIoOperation());
        }
        if (this.opCtx.getIoOperation().getStatus() == ILSMIOOperation.LSMIOOperationStatus.SUCCESS && this.opCtx.getIoOperation().getNewComponent().getComponentSize() > 0L) {
            this.lsmIndex.getHarness().addBulkLoadedComponent(this.opCtx.getIoOperation());
        }
    }

    private void fail(Throwable th) {
        if (!this.failed) {
            this.failed = true;
            ILSMIOOperation loadOp = this.opCtx.getIoOperation();
            loadOp.setFailure(th);
            this.lsmIndex.cleanUpFilesForFailedOperation(loadOp);
        }
    }
}

