/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public class FilterBulkLoader
implements IChainedComponentBulkLoader {
    private final ILSMComponentFilter filter;
    private final ITreeIndex treeIndex;
    protected final ILSMComponentFilterManager filterManager;
    protected final PermutingTupleReference indexTuple;
    protected final PermutingTupleReference filterTuple;
    protected final MultiComparator filterCmp;

    public FilterBulkLoader(ILSMComponentFilter filter, ITreeIndex treeIndex, ILSMComponentFilterManager filterManager, int[] indexFields, int[] filterFields, MultiComparator filterCmp) {
        this.filter = filter;
        this.treeIndex = treeIndex;
        this.filterManager = filterManager;
        this.indexTuple = new PermutingTupleReference(indexFields);
        this.filterTuple = new PermutingTupleReference(filterFields);
        this.filterCmp = filterCmp;
    }

    @Override
    public ITupleReference delete(ITupleReference tuple) throws HyracksDataException {
        this.indexTuple.reset(tuple);
        this.updateFilter(tuple);
        return this.indexTuple;
    }

    @Override
    public void cleanupArtifacts() throws HyracksDataException {
    }

    @Override
    public ITupleReference add(ITupleReference tuple) throws HyracksDataException {
        this.indexTuple.reset(tuple);
        this.updateFilter(tuple);
        return this.indexTuple;
    }

    @Override
    public void end() throws HyracksDataException {
        this.filterManager.writeFilter(this.filter, this.treeIndex);
    }

    @Override
    public void abort() throws HyracksDataException {
    }

    private void updateFilter(ITupleReference tuple) throws HyracksDataException {
        this.filterTuple.reset(tuple);
        this.filter.update((ITupleReference)this.filterTuple, this.filterCmp, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
    }

    public void writeFailed(ICachedPage page, Throwable failure) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFailed() {
        return false;
    }

    public Throwable getFailure() {
        return null;
    }
}

