/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public class ChainedLSMDiskComponentBulkLoader
implements ILSMDiskComponentBulkLoader {
    private List<IChainedComponentBulkLoader> bulkloaderChain = new ArrayList<IChainedComponentBulkLoader>();
    private final ILSMIOOperation operation;
    private final ILSMDiskComponent diskComponent;
    private final boolean cleanupEmptyComponent;
    private boolean isEmptyComponent = true;
    private boolean cleanedUpArtifacts = false;

    public ChainedLSMDiskComponentBulkLoader(ILSMIOOperation operation, ILSMDiskComponent diskComponent, boolean cleanupEmptyComponent) {
        this.operation = operation;
        this.diskComponent = diskComponent;
        this.cleanupEmptyComponent = cleanupEmptyComponent;
    }

    public void addBulkLoader(IChainedComponentBulkLoader bulkloader) {
        this.bulkloaderChain.add(bulkloader);
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t = tuple;
            int bulkloadersCount = this.bulkloaderChain.size();
            for (int i = 0; i < bulkloadersCount; ++i) {
                t = this.bulkloaderChain.get(i).add(t);
            }
        }
        catch (Throwable e) {
            this.operation.setFailure(e);
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void delete(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t = tuple;
            int bulkloadersCount = this.bulkloaderChain.size();
            for (int i = 0; i < bulkloadersCount; ++i) {
                t = this.bulkloaderChain.get(i).delete(t);
            }
        }
        catch (Throwable e) {
            this.operation.setFailure(e);
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void cleanupArtifacts() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            this.cleanedUpArtifacts = true;
            int bulkloadersCount = this.bulkloaderChain.size();
            for (int i = 0; i < bulkloadersCount; ++i) {
                this.bulkloaderChain.get(i).cleanupArtifacts();
            }
            this.diskComponent.deactivateAndDestroy();
        }
    }

    public void end() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            int bulkloadersCount = this.bulkloaderChain.size();
            for (int i = 0; i < bulkloadersCount; ++i) {
                this.bulkloaderChain.get(i).end();
            }
            if (this.isEmptyComponent && this.cleanupEmptyComponent) {
                this.cleanupArtifacts();
            }
        }
    }

    public void abort() throws HyracksDataException {
        this.operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
        int bulkloadersCount = this.bulkloaderChain.size();
        for (int i = 0; i < bulkloadersCount; ++i) {
            this.bulkloaderChain.get(i).abort();
        }
    }

    @Override
    public ILSMIOOperation getOperation() {
        return this.operation;
    }

    public void writeFailed(ICachedPage page, Throwable failure) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFailed() {
        int bulkloadersCount = this.bulkloaderChain.size();
        for (int i = 0; i < bulkloadersCount; ++i) {
            if (!this.bulkloaderChain.get(i).hasFailed()) continue;
            return true;
        }
        return false;
    }

    public Throwable getFailure() {
        int bulkloadersCount = this.bulkloaderChain.size();
        for (int i = 0; i < bulkloadersCount; ++i) {
            if (!this.bulkloaderChain.get(i).hasFailed()) continue;
            return this.bulkloaderChain.get(i).getFailure();
        }
        return null;
    }
}

