/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.IoOperationExecutor;

public class AsynchronousScheduler
implements ILSMIOOperationScheduler,
Closeable {
    private final ExecutorService executor;
    private final Map<String, ILSMIOOperation> runningFlushOperations = new HashMap<String, ILSMIOOperation>();
    private final Map<String, Deque<ILSMIOOperation>> waitingFlushOperations = new HashMap<String, Deque<ILSMIOOperation>>();
    private final Map<String, Throwable> failedGroups = new HashMap<String, Throwable>();

    public AsynchronousScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback) {
        this.executor = new IoOperationExecutor(threadFactory, this, callback, this.runningFlushOperations, this.waitingFlushOperations, this.failedGroups);
    }

    @Override
    public void scheduleOperation(ILSMIOOperation operation) {
        switch (operation.getIOOpertionType()) {
            case FLUSH: {
                this.scheduleFlush(operation);
                break;
            }
            case MERGE: {
                this.executor.submit(operation);
                break;
            }
            case NOOP: {
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type " + (Object)((Object)operation.getIOOpertionType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(ILSMIOOperation operation) {
        String id = operation.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            if (this.failedGroups.containsKey(id)) {
                operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
                operation.setFailure(new RuntimeException("Operation group " + id + " has permanently failed", this.failedGroups.get(id)));
                operation.complete();
                return;
            }
            if (this.runningFlushOperations.containsKey(id)) {
                if (this.waitingFlushOperations.containsKey(id)) {
                    this.waitingFlushOperations.get(id).offer(operation);
                } else {
                    ArrayDeque<ILSMIOOperation> q = new ArrayDeque<ILSMIOOperation>();
                    q.offer(operation);
                    this.waitingFlushOperations.put(id, q);
                }
            } else {
                this.runningFlushOperations.put(id, operation);
                this.executor.submit(operation);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }
}

