/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.sort.AbstractFrameSorter;

public class FrameSorterMergeSort
extends AbstractFrameSorter {
    private int[] tPointersTemp;

    public FrameSorterMergeSort(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int maxSortFrames, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this(ctx, bufferManager, maxSortFrames, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor, Integer.MAX_VALUE);
    }

    public FrameSorterMergeSort(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int maxSortFrames, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int outputLimit) throws HyracksDataException {
        super(ctx, bufferManager, maxSortFrames, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor, outputLimit);
    }

    @Override
    void sortTupleReferences() throws HyracksDataException {
        if (this.tPointersTemp == null || this.tPointersTemp.length < this.tPointers.length) {
            this.tPointersTemp = new int[this.tPointers.length];
        }
        this.sort(0, this.tupleCount);
    }

    @Override
    protected long getRequiredMemory(FrameTupleAccessor frameAccessor) {
        return super.getRequiredMemory(frameAccessor) + (long)(this.ptrSize * frameAccessor.getTupleCount() * 4);
    }

    @Override
    public void close() {
        super.close();
        this.tPointersTemp = null;
    }

    void sort(int offset, int length) throws HyracksDataException {
        int end = offset + length;
        for (int step = 1; step < length; step *= 2) {
            for (int i = offset; i < end; i += 2 * step) {
                int next = i + step;
                if (next < end) {
                    this.merge(i, next, step, Math.min(step, end - next));
                    continue;
                }
                this.copy(this.tPointers, i, this.tPointersTemp, i, end - i);
            }
            int[] tmp = this.tPointersTemp;
            this.tPointersTemp = this.tPointers;
            this.tPointers = tmp;
        }
    }

    private void merge(int start1, int start2, int len1, int len2) throws HyracksDataException {
        int rest;
        int targetPos = start1;
        int pos1 = start1;
        int pos2 = start2;
        int end1 = start1 + len1 - 1;
        int end2 = start2 + len2 - 1;
        while (pos1 <= end1 && pos2 <= end2) {
            int cmp = this.compare(pos1, pos2);
            if (cmp <= 0) {
                this.copy(this.tPointers, pos1, this.tPointersTemp, targetPos);
                ++pos1;
            } else {
                this.copy(this.tPointers, pos2, this.tPointersTemp, targetPos);
                ++pos2;
            }
            ++targetPos;
        }
        if (pos1 <= end1) {
            rest = end1 - pos1 + 1;
            this.copy(this.tPointers, pos1, this.tPointersTemp, targetPos, rest);
        }
        if (pos2 <= end2) {
            rest = end2 - pos2 + 1;
            this.copy(this.tPointers, pos2, this.tPointersTemp, targetPos, rest);
        }
    }
}

