/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFamily;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.join.InMemoryHashJoin;
import org.apache.hyracks.dataflow.std.join.NestedLoopJoin;
import org.apache.hyracks.dataflow.std.join.OptimizedHybridHashJoin;
import org.apache.hyracks.dataflow.std.structures.SerializableHashTable;
import org.apache.hyracks.dataflow.std.util.FrameTuplePairComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptimizedHybridHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int BUILD_AND_PARTITION_ACTIVITY_ID = 0;
    private static final int PARTITION_AND_JOIN_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private static final double NLJ_SWITCH_THRESHOLD = 0.8;
    private static final String PROBE_REL = "RelR";
    private static final String BUILD_REL = "RelS";
    private final int memSizeInFrames;
    private final int inputsize0;
    private final double fudgeFactor;
    private final int[] probeKeys;
    private final int[] buildKeys;
    private final IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final ITuplePairComparatorFactory tuplePairComparatorFactoryProbe2Build;
    private final ITuplePairComparatorFactory tuplePairComparatorFactoryBuild2Probe;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final IMissingWriterFactory[] nonMatchWriterFactories;
    private boolean skipInMemoryHJ = false;
    private boolean forceNLJ = false;
    private boolean forceRoleReversal = false;
    private static final Logger LOGGER = LogManager.getLogger();

    public OptimizedHybridHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memSizeInFrames, int inputsize0, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, ITuplePairComparatorFactory tupPaircomparatorFactory01, ITuplePairComparatorFactory tupPaircomparatorFactory10, IPredicateEvaluatorFactory predEvaluatorFactory, boolean isLeftOuter, IMissingWriterFactory[] nonMatchWriterFactories) {
        super(spec, 2, 1);
        this.memSizeInFrames = memSizeInFrames;
        this.inputsize0 = inputsize0;
        this.fudgeFactor = factor;
        this.probeKeys = keys0;
        this.buildKeys = keys1;
        this.hashFunctionGeneratorFactories = hashFunctionGeneratorFactories;
        this.comparatorFactories = comparatorFactories;
        this.tuplePairComparatorFactoryProbe2Build = tupPaircomparatorFactory01;
        this.tuplePairComparatorFactoryBuild2Probe = tupPaircomparatorFactory10;
        this.outRecDescs[0] = recordDescriptor;
        this.predEvaluatorFactory = predEvaluatorFactory;
        this.isLeftOuter = isLeftOuter;
        this.nonMatchWriterFactories = nonMatchWriterFactories;
    }

    public OptimizedHybridHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memSizeInFrames, int inputsize0, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, ITuplePairComparatorFactory tupPaircomparatorFactory01, ITuplePairComparatorFactory tupPaircomparatorFactory10, IPredicateEvaluatorFactory predEvaluatorFactory) {
        this(spec, memSizeInFrames, inputsize0, factor, keys0, keys1, hashFunctionGeneratorFactories, comparatorFactories, recordDescriptor, tupPaircomparatorFactory01, tupPaircomparatorFactory10, predEvaluatorFactory, false, null);
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId buildAid = new ActivityId(this.odId, 0);
        ActivityId probeAid = new ActivityId(this.odId, 1);
        PartitionAndBuildActivityNode phase1 = new PartitionAndBuildActivityNode(buildAid, probeAid);
        ProbeAndJoinActivityNode phase2 = new ProbeAndJoinActivityNode(probeAid, buildAid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)phase1);
        builder.addSourceEdge(1, (IActivity)phase1, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)phase2);
        builder.addSourceEdge(0, (IActivity)phase2, 0);
        builder.addBlockingEdge((IActivity)phase1, (IActivity)phase2);
        builder.addTargetEdge(0, (IActivity)phase2, 0);
    }

    private int getNumberOfPartitions(int memorySize, int buildSize, double factor, int nPartitions) throws HyracksDataException {
        int numberOfPartitions = 0;
        if (memorySize <= 2) {
            throw new HyracksDataException("Not enough memory is available for Hybrid Hash Join.");
        }
        if ((double)memorySize > (double)buildSize * factor) {
            return 2;
        }
        numberOfPartitions = (int)Math.ceil(((double)buildSize * factor / (double)nPartitions - (double)memorySize) / (double)(memorySize - 1));
        if ((numberOfPartitions = Math.max(2, numberOfPartitions)) > memorySize) {
            numberOfPartitions = (int)Math.ceil(Math.sqrt((double)buildSize * factor / (double)nPartitions));
            return Math.max(2, Math.min(numberOfPartitions, memorySize));
        }
        return numberOfPartitions;
    }

    private class ProbeAndJoinActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId buildAid;

        public ProbeAndJoinActivityNode(ActivityId id, ActivityId buildAid) {
            super(id);
            this.buildAid = buildAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
            ArrayTupleBuilder nullTupleBuild;
            final RecordDescriptor buildRd = recordDescProvider.getInputRecordDescriptor(this.buildAid, 0);
            final RecordDescriptor probeRd = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length];
            final ITuplePairComparator nljComparatorProbe2Build = OptimizedHybridHashJoinOperatorDescriptor.this.tuplePairComparatorFactoryProbe2Build.createTuplePairComparator(ctx);
            final ITuplePairComparator nljComparatorBuild2Probe = OptimizedHybridHashJoinOperatorDescriptor.this.tuplePairComparatorFactoryBuild2Probe.createTuplePairComparator(ctx);
            final IPredicateEvaluator predEvaluator = OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            for (int i = 0; i < OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            final IMissingWriter[] nonMatchWriter = OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter ? new IMissingWriter[OptimizedHybridHashJoinOperatorDescriptor.this.nonMatchWriterFactories.length] : null;
            ArrayTupleBuilder arrayTupleBuilder = nullTupleBuild = OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter ? new ArrayTupleBuilder(buildRd.getFieldCount()) : null;
            if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter) {
                DataOutput out = nullTupleBuild.getDataOutput();
                for (int i = 0; i < OptimizedHybridHashJoinOperatorDescriptor.this.nonMatchWriterFactories.length; ++i) {
                    nonMatchWriter[i] = OptimizedHybridHashJoinOperatorDescriptor.this.nonMatchWriterFactories[i].createMissingWriter();
                    nonMatchWriter[i].writeMissing(out);
                    nullTupleBuild.addFieldEndOffset();
                }
            }
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private BuildAndPartitionTaskState state;
                private IFrame rPartbuff;
                private FrameTupleAppender nullResultAppender;
                private FrameTupleAccessor probeTupleAccessor;
                private boolean failed;
                {
                    this.rPartbuff = new VSizeFrame((IHyracksFrameMgrContext)ctx);
                    this.nullResultAppender = null;
                    this.failed = false;
                }

                public void open() throws HyracksDataException {
                    this.state = (BuildAndPartitionTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(OptimizedHybridHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.writer.open();
                    this.state.hybridHJ.initProbe();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("OptimizedHybridHashJoin is starting the probe phase.");
                    }
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.hybridHJ.probe(buffer, this.writer);
                }

                public void fail() throws HyracksDataException {
                    this.failed = true;
                    this.writer.fail();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws HyracksDataException {
                    if (this.failed) {
                        try {
                            this.state.hybridHJ.clearBuildTempFiles();
                            this.state.hybridHJ.clearProbeTempFiles();
                        }
                        finally {
                            this.writer.close();
                        }
                        this.logProbeComplete();
                        return;
                    }
                    try {
                        try {
                            this.state.hybridHJ.completeProbe(this.writer);
                        }
                        finally {
                            this.state.hybridHJ.releaseResource();
                        }
                        BitSet partitionStatus = this.state.hybridHJ.getPartitionStatus();
                        this.rPartbuff.reset();
                        int pid = partitionStatus.nextSetBit(0);
                        while (pid >= 0) {
                            RunFileReader bReader = this.state.hybridHJ.getBuildRFReader(pid);
                            RunFileReader pReader = this.state.hybridHJ.getProbeRFReader(pid);
                            if (bReader == null || pReader == null) {
                                if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter && pReader != null) {
                                    this.appendNullToProbeTuples(pReader);
                                }
                            } else {
                                int bSize = this.state.hybridHJ.getBuildPartitionSizeInTup(pid);
                                int pSize = this.state.hybridHJ.getProbePartitionSizeInTup(pid);
                                this.joinPartitionPair(bReader, pReader, bSize, pSize, 1);
                            }
                            pid = partitionStatus.nextSetBit(pid + 1);
                        }
                    }
                    catch (Exception e) {
                        this.writer.fail();
                        this.state.hybridHJ.clearBuildTempFiles();
                        this.state.hybridHJ.clearProbeTempFiles();
                        throw e;
                    }
                    finally {
                        try {
                            this.logProbeComplete();
                        }
                        finally {
                            this.writer.close();
                        }
                    }
                }

                private void logProbeComplete() {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("OptimizedHybridHashJoin closed its probe phase");
                    }
                }

                private void joinPartitionPair(RunFileReader buildSideReader, RunFileReader probeSideReader, int buildSizeInTuple, int probeSizeInTuple, int level) throws HyracksDataException {
                    ITuplePartitionComputer probeHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(level);
                    ITuplePartitionComputer buildHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(level);
                    int frameSize = ctx.getInitialFrameSize();
                    long buildPartSize = (long)Math.ceil((double)buildSideReader.getFileSize() / (double)frameSize);
                    long probePartSize = (long)Math.ceil((double)probeSideReader.getFileSize() / (double)frameSize);
                    int beforeMax = Math.max(buildSizeInTuple, probeSizeInTuple);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\n>>>Joining Partition Pairs (thread_id " + Thread.currentThread().getId() + ") (pid ) - (level " + level + ") - BuildSize:\t" + buildPartSize + "\tProbeSize:\t" + probePartSize + " - MemForJoin " + this.state.memForJoin + "  - LeftOuter is " + OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter);
                    }
                    long expectedHashTableSizeForBuildInFrame = SerializableHashTable.getExpectedTableFrameCount(buildSizeInTuple, frameSize);
                    long expectedHashTableSizeForProbeInFrame = SerializableHashTable.getExpectedTableFrameCount(probeSizeInTuple, frameSize);
                    if (!OptimizedHybridHashJoinOperatorDescriptor.this.skipInMemoryHJ && (buildPartSize + expectedHashTableSizeForBuildInFrame < (long)this.state.memForJoin || probePartSize + expectedHashTableSizeForProbeInFrame < (long)this.state.memForJoin && !OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter)) {
                        int tabSize = -1;
                        if (!OptimizedHybridHashJoinOperatorDescriptor.this.forceRoleReversal && (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || buildPartSize < probePartSize)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\t>>>Case 1.1 (IsLeftOuter || buildSize<probe) AND ApplyInMemHJ - [Level " + level + "]");
                            }
                            if ((tabSize = buildSizeInTuple) == 0) {
                                throw new HyracksDataException("Trying to join an empty partition. Invalid table size for inMemoryHashJoin.");
                            }
                            this.applyInMemHashJoin(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, tabSize, buildRd, probeRd, buildHpc, probeHpc, buildSideReader, probeSideReader);
                        } else {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\t>>>Case 1.2. (NoIsLeftOuter || probe<build) AND ApplyInMemHJWITH RoleReversal - [Level " + level + "]");
                            }
                            if ((tabSize = probeSizeInTuple) == 0) {
                                throw new HyracksDataException("Trying to join an empty partition. Invalid table size for inMemoryHashJoin.");
                            }
                            this.applyInMemHashJoin(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, tabSize, probeRd, buildRd, probeHpc, buildHpc, probeSideReader, buildSideReader);
                        }
                    } else {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("\t>>>Case 2. ApplyRecursiveHHJ - [Level " + level + "]");
                        }
                        if (!OptimizedHybridHashJoinOperatorDescriptor.this.forceRoleReversal && (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || buildPartSize < probePartSize)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\t\t>>>Case 2.1 - RecursiveHHJ WITH (isLeftOuter || build<probe) - [Level " + level + "]");
                            }
                            this.applyHybridHashJoin((int)buildPartSize, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, probeRd, buildRd, probeHpc, buildHpc, probeSideReader, buildSideReader, level, beforeMax);
                        } else {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\t\t>>>Case 2.2. - RecursiveHHJ WITH RoleReversal - [Level " + level + "]");
                            }
                            this.applyHybridHashJoin((int)probePartSize, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, buildRd, probeRd, buildHpc, probeHpc, buildSideReader, probeSideReader, level, beforeMax);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void applyHybridHashJoin(int tableSize, String PROBE_REL, String BUILD_REL, int[] probeKeys, int[] buildKeys, RecordDescriptor probeRd2, RecordDescriptor buildRd2, ITuplePartitionComputer probeHpc, ITuplePartitionComputer buildHpc, RunFileReader probeSideReader, RunFileReader buildSideReader, int level, long beforeMax) throws HyracksDataException {
                    boolean isReversed;
                    boolean bl = isReversed = probeKeys == OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys && buildKeys == OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys;
                    assert (!OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || !isReversed) : "LeftOut Join can not reverse roles";
                    int n = OptimizedHybridHashJoinOperatorDescriptor.this.getNumberOfPartitions(this.state.memForJoin, tableSize, OptimizedHybridHashJoinOperatorDescriptor.this.fudgeFactor, nPartitions);
                    OptimizedHybridHashJoin rHHj = new OptimizedHybridHashJoin(ctx, this.state.memForJoin, n, PROBE_REL, BUILD_REL, probeKeys, buildKeys, comparators, probeRd2, buildRd2, probeHpc, buildHpc, predEvaluator, OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, OptimizedHybridHashJoinOperatorDescriptor.this.nonMatchWriterFactories);
                    rHHj.setIsReversed(isReversed);
                    try {
                        buildSideReader.open();
                        try {
                            rHHj.initBuild();
                            this.rPartbuff.reset();
                            while (buildSideReader.nextFrame(this.rPartbuff)) {
                                rHHj.build(this.rPartbuff.getBuffer());
                            }
                        }
                        finally {
                            rHHj.closeBuild();
                        }
                    }
                    finally {
                        buildSideReader.close();
                    }
                    try {
                        probeSideReader.open();
                        this.rPartbuff.reset();
                        try {
                            rHHj.initProbe();
                            while (probeSideReader.nextFrame(this.rPartbuff)) {
                                rHHj.probe(this.rPartbuff.getBuffer(), this.writer);
                            }
                            rHHj.completeProbe(this.writer);
                        }
                        finally {
                            rHHj.releaseResource();
                        }
                    }
                    finally {
                        probeSideReader.close();
                    }
                    try {
                        int maxAfterBuildSize = rHHj.getMaxBuildPartitionSize();
                        int maxAfterProbeSize = rHHj.getMaxProbePartitionSize();
                        int afterMax = Math.max(maxAfterBuildSize, maxAfterProbeSize);
                        BitSet rPStatus = rHHj.getPartitionStatus();
                        if (!OptimizedHybridHashJoinOperatorDescriptor.this.forceNLJ && (double)afterMax < 0.8 * (double)beforeMax) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\t\t>>>Case 2.1.1 - KEEP APPLYING RecursiveHHJ WITH (isLeftOuter || build<probe) - [Level " + level + "]");
                            }
                            int rPid = rPStatus.nextSetBit(0);
                            while (rPid >= 0) {
                                RunFileReader rbrfw = rHHj.getBuildRFReader(rPid);
                                RunFileReader rprfw = rHHj.getProbeRFReader(rPid);
                                int rbSizeInTuple = rHHj.getBuildPartitionSizeInTup(rPid);
                                int rpSizeInTuple = rHHj.getProbePartitionSizeInTup(rPid);
                                if (rbrfw == null || rprfw == null) {
                                    if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter && rprfw != null) {
                                        this.appendNullToProbeTuples(rprfw);
                                    }
                                } else if (isReversed) {
                                    this.joinPartitionPair(rprfw, rbrfw, rpSizeInTuple, rbSizeInTuple, level + 1);
                                } else {
                                    this.joinPartitionPair(rbrfw, rprfw, rbSizeInTuple, rpSizeInTuple, level + 1);
                                }
                                rPid = rPStatus.nextSetBit(rPid + 1);
                            }
                        } else {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\t\t>>>Case 2.1.2 - SWITCHED to NLJ RecursiveHHJ WITH (isLeftOuter || build<probe) - [Level " + level + "]");
                            }
                            int rPid = rPStatus.nextSetBit(0);
                            while (rPid >= 0) {
                                RunFileReader rbrfw = rHHj.getBuildRFReader(rPid);
                                RunFileReader rprfw = rHHj.getProbeRFReader(rPid);
                                if (rbrfw == null || rprfw == null) {
                                    if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter && rprfw != null) {
                                        this.appendNullToProbeTuples(rprfw);
                                    }
                                } else {
                                    int buildSideInTups = rHHj.getBuildPartitionSizeInTup(rPid);
                                    int probeSideInTups = rHHj.getProbePartitionSizeInTup(rPid);
                                    if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || probeSideInTups < buildSideInTups) {
                                        this.applyNestedLoopJoin(probeRd2, buildRd2, OptimizedHybridHashJoinOperatorDescriptor.this.memSizeInFrames, rprfw, rbrfw);
                                    } else {
                                        this.applyNestedLoopJoin(buildRd2, probeRd2, OptimizedHybridHashJoinOperatorDescriptor.this.memSizeInFrames, rbrfw, rprfw);
                                    }
                                }
                                rPid = rPStatus.nextSetBit(rPid + 1);
                            }
                        }
                    }
                    catch (Exception e) {
                        rHHj.clearBuildTempFiles();
                        rHHj.clearProbeTempFiles();
                        throw e;
                    }
                }

                private void appendNullToProbeTuples(RunFileReader probReader) throws HyracksDataException {
                    if (this.nullResultAppender == null) {
                        this.nullResultAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
                    }
                    if (this.probeTupleAccessor == null) {
                        this.probeTupleAccessor = new FrameTupleAccessor(probeRd);
                    }
                    try {
                        probReader.open();
                        while (probReader.nextFrame(this.rPartbuff)) {
                            this.probeTupleAccessor.reset(this.rPartbuff.getBuffer());
                            for (int tid = 0; tid < this.probeTupleAccessor.getTupleCount(); ++tid) {
                                FrameUtils.appendConcatToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.nullResultAppender, (IFrameTupleAccessor)this.probeTupleAccessor, (int)tid, (int[])nullTupleBuild.getFieldEndOffsets(), (byte[])nullTupleBuild.getByteArray(), (int)0, (int)nullTupleBuild.getSize());
                            }
                        }
                        this.nullResultAppender.write(this.writer, true);
                    }
                    finally {
                        probReader.close();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void applyInMemHashJoin(int[] bKeys, int[] pKeys, int tabSize, RecordDescriptor buildRDesc, RecordDescriptor probeRDesc, ITuplePartitionComputer hpcRepBuild, ITuplePartitionComputer hpcRepProbe, RunFileReader bReader, RunFileReader pReader) throws HyracksDataException {
                    boolean isReversed;
                    boolean bl = isReversed = pKeys == OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys && bKeys == OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys;
                    assert (!OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || !isReversed) : "LeftOut Join can not reverse roles";
                    DeallocatableFramePool framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)ctx, this.state.memForJoin * ctx.getInitialFrameSize());
                    FramePoolBackedFrameBufferManager bufferManager = new FramePoolBackedFrameBufferManager(framePool);
                    SerializableHashTable table = new SerializableHashTable(tabSize, (IHyracksFrameMgrContext)ctx, bufferManager);
                    InMemoryHashJoin joiner = new InMemoryHashJoin(ctx, new FrameTupleAccessor(probeRDesc), hpcRepProbe, new FrameTupleAccessor(buildRDesc), buildRDesc, hpcRepBuild, new FrameTuplePairComparator(pKeys, bKeys, comparators), OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, nonMatchWriter, table, predEvaluator, isReversed, bufferManager);
                    try {
                        bReader.open();
                        this.rPartbuff.reset();
                        while (bReader.nextFrame(this.rPartbuff)) {
                            ByteBuffer copyBuffer = bufferManager.acquireFrame(this.rPartbuff.getFrameSize());
                            if (copyBuffer == null) {
                                if (joiner.compactHashTable() > 0) {
                                    copyBuffer = bufferManager.acquireFrame(this.rPartbuff.getFrameSize());
                                }
                                if (copyBuffer == null) {
                                    throw new HyracksDataException("Can't allocate one more frame. Assign more memory to InMemoryHashJoin.");
                                }
                            }
                            FrameUtils.copyAndFlip((ByteBuffer)this.rPartbuff.getBuffer(), (ByteBuffer)copyBuffer);
                            joiner.build(copyBuffer);
                            this.rPartbuff.reset();
                        }
                    }
                    finally {
                        bReader.close();
                    }
                    try {
                        pReader.open();
                        this.rPartbuff.reset();
                        try {
                            while (pReader.nextFrame(this.rPartbuff)) {
                                joiner.join(this.rPartbuff.getBuffer(), this.writer);
                                this.rPartbuff.reset();
                            }
                            joiner.completeJoin(this.writer);
                        }
                        finally {
                            joiner.releaseMemory();
                        }
                    }
                    finally {
                        try {
                            pReader.close();
                        }
                        finally {
                            joiner.closeTable();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void applyNestedLoopJoin(RecordDescriptor outerRd, RecordDescriptor innerRd, int memorySize, RunFileReader outerReader, RunFileReader innerReader) throws HyracksDataException {
                    boolean isReversed;
                    boolean bl = isReversed = outerRd == buildRd && innerRd == probeRd;
                    assert (!OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || !isReversed) : "LeftOut Join can not reverse roles";
                    ITuplePairComparator nljComptorOuterInner = isReversed ? nljComparatorBuild2Probe : nljComparatorProbe2Build;
                    NestedLoopJoin nlj = new NestedLoopJoin(ctx, new FrameTupleAccessor(outerRd), new FrameTupleAccessor(innerRd), nljComptorOuterInner, memorySize, predEvaluator, OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, nonMatchWriter);
                    nlj.setIsReversed(isReversed);
                    VSizeFrame cacheBuff = new VSizeFrame((IHyracksFrameMgrContext)ctx);
                    try {
                        innerReader.open();
                        while (innerReader.nextFrame((IFrame)cacheBuff)) {
                            nlj.cache(cacheBuff.getBuffer());
                            cacheBuff.reset();
                        }
                    }
                    finally {
                        try {
                            nlj.closeCache();
                        }
                        finally {
                            innerReader.close();
                        }
                    }
                    try {
                        VSizeFrame joinBuff = new VSizeFrame((IHyracksFrameMgrContext)ctx);
                        outerReader.open();
                        try {
                            while (outerReader.nextFrame((IFrame)joinBuff)) {
                                nlj.join(joinBuff.getBuffer(), this.writer);
                                joinBuff.reset();
                            }
                            nlj.completeJoin(this.writer);
                        }
                        finally {
                            nlj.releaseMemory();
                        }
                    }
                    finally {
                        outerReader.close();
                    }
                }
            };
            return op;
        }
    }

    private class PartitionAndBuildActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId probeAid;

        public PartitionAndBuildActivityNode(ActivityId id, ActivityId probeAid) {
            super(id);
            this.probeAid = probeAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) {
            final RecordDescriptor buildRd = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final RecordDescriptor probeRd = recordDescProvider.getInputRecordDescriptor(this.probeAid, 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length];
            for (int i = 0; i < OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            final IPredicateEvaluator predEvaluator = OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private BuildAndPartitionTaskState state;
                ITuplePartitionComputer probeHpc;
                ITuplePartitionComputer buildHpc;
                boolean isFailed;
                {
                    this.state = new BuildAndPartitionTaskState(ctx.getJobletContext().getJobId(), new TaskId(PartitionAndBuildActivityNode.this.getActivityId(), partition));
                    this.probeHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(0);
                    this.buildHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(0);
                    this.isFailed = false;
                }

                public void open() throws HyracksDataException {
                    if (OptimizedHybridHashJoinOperatorDescriptor.this.memSizeInFrames <= 2) {
                        throw new HyracksDataException("Not enough memory is assigend for Hybrid Hash Join.");
                    }
                    this.state.memForJoin = OptimizedHybridHashJoinOperatorDescriptor.this.memSizeInFrames - 2;
                    this.state.numOfPartitions = OptimizedHybridHashJoinOperatorDescriptor.this.getNumberOfPartitions(this.state.memForJoin, OptimizedHybridHashJoinOperatorDescriptor.this.inputsize0, OptimizedHybridHashJoinOperatorDescriptor.this.fudgeFactor, nPartitions);
                    this.state.hybridHJ = new OptimizedHybridHashJoin(ctx, this.state.memForJoin, this.state.numOfPartitions, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, comparators, probeRd, buildRd, this.probeHpc, this.buildHpc, predEvaluator, OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, OptimizedHybridHashJoinOperatorDescriptor.this.nonMatchWriterFactories);
                    this.state.hybridHJ.initBuild();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("OptimizedHybridHashJoin is starting the build phase with " + this.state.numOfPartitions + " partitions using " + this.state.memForJoin + " frames for memory.");
                    }
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.hybridHJ.build(buffer);
                }

                public void close() throws HyracksDataException {
                    this.state.hybridHJ.closeBuild();
                    if (this.isFailed) {
                        this.state.hybridHJ.clearBuildTempFiles();
                    } else {
                        ctx.setStateObject((IStateObject)this.state);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("OptimizedHybridHashJoin closed its build phase");
                        }
                    }
                }

                public void fail() throws HyracksDataException {
                    this.isFailed = true;
                }
            };
            return op;
        }
    }

    public static class BuildAndPartitionTaskState
    extends AbstractStateObject {
        private int memForJoin;
        private int numOfPartitions;
        private OptimizedHybridHashJoin hybridHJ;

        public BuildAndPartitionTaskState() {
        }

        private BuildAndPartitionTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        @Override
        public void toBytes(DataOutput out) throws IOException {
        }

        @Override
        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

