/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.sort;

import java.util.List;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;
import org.apache.hyracks.dataflow.std.sort.AbstractExternalSortRunMerger;
import org.apache.hyracks.dataflow.std.sort.ISorter;

public class ExternalSortGroupByRunMerger
extends AbstractExternalSortRunMerger {
    private final RecordDescriptor inputRecordDesc;
    private final RecordDescriptor partialAggRecordDesc;
    private final RecordDescriptor outRecordDesc;
    private final int[] groupFields;
    private final IAggregatorDescriptorFactory mergeAggregatorFactory;
    private final IAggregatorDescriptorFactory partialAggregatorFactory;
    private final boolean localSide;
    private final int[] mergeSortFields;
    private final int[] mergeGroupFields;
    private final IBinaryComparator[] groupByComparators;

    public ExternalSortGroupByRunMerger(IHyracksTaskContext ctx, ISorter frameSorter, List<GeneratedRunFileReader> runs, int[] sortFields, RecordDescriptor inRecordDesc, RecordDescriptor partialAggRecordDesc, RecordDescriptor outRecordDesc, int framesLimit, IFrameWriter writer, int[] groupFields, INormalizedKeyComputer nmk, IBinaryComparator[] comparators, IAggregatorDescriptorFactory partialAggregatorFactory, IAggregatorDescriptorFactory aggregatorFactory, boolean localStage) {
        super(ctx, frameSorter, runs, comparators, nmk, partialAggRecordDesc, framesLimit, writer);
        int i;
        this.inputRecordDesc = inRecordDesc;
        this.partialAggRecordDesc = partialAggRecordDesc;
        this.outRecordDesc = outRecordDesc;
        this.groupFields = groupFields;
        this.mergeAggregatorFactory = aggregatorFactory;
        this.partialAggregatorFactory = partialAggregatorFactory;
        this.localSide = localStage;
        int numSortFields = sortFields.length;
        this.mergeSortFields = new int[numSortFields];
        for (int i2 = 0; i2 < numSortFields; ++i2) {
            this.mergeSortFields[i2] = i2;
        }
        int numGroupFields = groupFields.length;
        this.mergeGroupFields = new int[numGroupFields];
        for (i = 0; i < numGroupFields; ++i) {
            this.mergeGroupFields[i] = i;
        }
        this.groupByComparators = new IBinaryComparator[Math.min(this.mergeGroupFields.length, comparators.length)];
        for (i = 0; i < this.groupByComparators.length; ++i) {
            this.groupByComparators[i] = comparators[i];
        }
    }

    @Override
    protected IFrameWriter prepareSkipMergingFinalResultWriter(IFrameWriter nextWriter) throws HyracksDataException {
        IAggregatorDescriptorFactory aggregatorFactory = this.localSide ? this.partialAggregatorFactory : this.mergeAggregatorFactory;
        boolean outputPartial = false;
        return new PreclusteredGroupWriter(this.ctx, this.groupFields, this.groupByComparators, aggregatorFactory, this.inputRecordDesc, this.outRecordDesc, nextWriter, outputPartial);
    }

    @Override
    protected RunFileWriter prepareIntermediateMergeRunFile() throws HyracksDataException {
        FileReference newRun = this.ctx.createManagedWorkspaceFile(ExternalSortGroupByRunMerger.class.getSimpleName());
        return new RunFileWriter(newRun, this.ctx.getIoManager());
    }

    @Override
    protected IFrameWriter prepareIntermediateMergeResultWriter(RunFileWriter mergeFileWriter) throws HyracksDataException {
        IAggregatorDescriptorFactory aggregatorFactory = this.localSide ? this.mergeAggregatorFactory : this.partialAggregatorFactory;
        boolean outputPartial = true;
        return new PreclusteredGroupWriter(this.ctx, this.mergeGroupFields, this.groupByComparators, aggregatorFactory, this.partialAggRecordDesc, this.partialAggRecordDesc, (IFrameWriter)mergeFileWriter, outputPartial);
    }

    @Override
    protected IFrameWriter prepareFinalMergeResultWriter(IFrameWriter nextWriter) throws HyracksDataException {
        boolean outputPartial = false;
        return new PreclusteredGroupWriter(this.ctx, this.mergeGroupFields, this.groupByComparators, this.mergeAggregatorFactory, this.partialAggRecordDesc, this.outRecordDesc, nextWriter, outputPartial);
    }

    @Override
    protected int[] getSortFields() {
        return this.mergeSortFields;
    }
}

