/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.MappedFileSplit;
import org.apache.hyracks.dataflow.std.file.ConstantFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoragePathUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private StoragePathUtil() {
    }

    public static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraints(FileSplit[] splits) {
        ConstantFileSplitProvider splitProvider = new ConstantFileSplitProvider(splits);
        String[] loc = new String[splits.length];
        for (int p = 0; p < splits.length; ++p) {
            loc[p] = splits[p].getNodeName();
        }
        AlgebricksAbsolutePartitionConstraint pc = new AlgebricksAbsolutePartitionConstraint(loc);
        return new Pair((Object)splitProvider, (Object)pc);
    }

    public static FileSplit getFileSplitForClusterPartition(ClusterPartition partition, String relativePath) {
        return new MappedFileSplit(partition.getActiveNodeId(), relativePath, partition.getIODeviceNum());
    }

    public static String prepareStoragePartitionPath(int partitonId) {
        return Paths.get("storage", "partition_" + partitonId).toString();
    }

    public static String prepareDataverseIndexName(String dataverseName, String datasetName, String idxName, long rebalanceCount) {
        return StoragePathUtil.prepareDataverseIndexName(dataverseName, StoragePathUtil.prepareFullIndexName(datasetName, idxName, rebalanceCount));
    }

    public static String prepareDataverseIndexName(String dataverseName, String fullIndexName) {
        return dataverseName + File.separator + fullIndexName;
    }

    private static String prepareFullIndexName(String datasetName, String idxName, long rebalanceCount) {
        return datasetName + File.separator + rebalanceCount + File.separator + idxName;
    }

    public static int getPartitionNumFromRelativePath(String relativePath) {
        int startIdx = relativePath.indexOf("partition_") + "partition_".length();
        String partition = relativePath.substring(startIdx, relativePath.indexOf(File.separatorChar, startIdx));
        return Integer.parseInt(partition);
    }

    public static String getIndexFileRelativePath(String fileAbsolutePath) {
        return ResourceReference.of(fileAbsolutePath).getRelativePath().toString();
    }

    public static String getFileRelativePath(String fileAbsolutePath) {
        return ResourceReference.of(fileAbsolutePath).getFileRelativePath().toString();
    }

    public static File createFile(String name, int count) throws HyracksDataException {
        try {
            String fileName = name + "_" + count;
            File file = new File(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                boolean success = file.createNewFile();
                if (!success) {
                    throw new HyracksDataException("Unable to create spill file " + fileName);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Created spill file " + file.getAbsolutePath());
                }
            } else {
                throw new HyracksDataException("spill file " + fileName + " already exists");
            }
            return file;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static String getIndexNameFromPath(String path) {
        return Paths.get(path, new String[0]).getFileName().toString();
    }

    public static Path getIndexPath(IIOManager ioManager, ResourceReference ref) throws HyracksDataException {
        return ioManager.resolve(ref.getRelativePath().toString()).getFile().toPath();
    }
}

