/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.net.InetSocketAddress;

public class ReplicaIdentifier {
    private final int partition;
    private final InetSocketAddress location;
    private final String id;

    private ReplicaIdentifier(int partition, InetSocketAddress location) {
        this.partition = partition;
        this.location = location;
        this.id = partition + "@" + location.toString();
    }

    public static ReplicaIdentifier of(int partition, InetSocketAddress location) {
        return new ReplicaIdentifier(partition, location);
    }

    public int getPartition() {
        return this.partition;
    }

    public InetSocketAddress getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaIdentifier that = (ReplicaIdentifier)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

