/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexCheckpoint {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final long INITIAL_CHECKPOINT_ID = 0L;
    private long id;
    private long validComponentSequence;
    private long lowWatermark;
    private long lastComponentId;
    private Map<Long, Long> masterNodeFlushMap;

    public static IndexCheckpoint first(long lastComponentSequence, long lowWatermark, long validComponentId) {
        IndexCheckpoint firstCheckpoint = new IndexCheckpoint();
        firstCheckpoint.id = 0L;
        firstCheckpoint.lowWatermark = lowWatermark;
        firstCheckpoint.validComponentSequence = lastComponentSequence;
        firstCheckpoint.lastComponentId = validComponentId;
        firstCheckpoint.masterNodeFlushMap = new HashMap<Long, Long>();
        return firstCheckpoint;
    }

    public static IndexCheckpoint next(IndexCheckpoint latest, long lowWatermark, long validComponentSequence, long lastComponentId) {
        if (lowWatermark < latest.getLowWatermark()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("low watermark {} less than the latest checkpoint low watermark {}", (Object)lowWatermark, (Object)latest);
            }
            throw new IllegalStateException("Low watermark should always be increasing");
        }
        IndexCheckpoint next = new IndexCheckpoint();
        next.id = latest.getId() + 1L;
        next.lowWatermark = lowWatermark;
        next.lastComponentId = lastComponentId;
        next.validComponentSequence = validComponentSequence;
        next.masterNodeFlushMap = latest.getMasterNodeFlushMap();
        next.masterNodeFlushMap.values().removeIf(lsn -> lsn <= lowWatermark);
        return next;
    }

    @JsonCreator
    private IndexCheckpoint() {
    }

    public long getValidComponentSequence() {
        return this.validComponentSequence;
    }

    public long getLowWatermark() {
        return this.lowWatermark;
    }

    public long getLastComponentId() {
        return this.lastComponentId;
    }

    public Map<Long, Long> getMasterNodeFlushMap() {
        return this.masterNodeFlushMap;
    }

    public long getId() {
        return this.id;
    }

    public String asJson() throws HyracksDataException {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static IndexCheckpoint fromJson(String json) throws HyracksDataException {
        try {
            return (IndexCheckpoint)OBJECT_MAPPER.readValue(json, IndexCheckpoint.class);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String toString() {
        try {
            return this.asJson();
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }
}

