/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;

public class MetadataProperties
extends AbstractProperties {
    public MetadataProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public String getMetadataNodeName() {
        return this.accessor.getString(Option.METADATA_NODE);
    }

    public Map<String, String[]> getStores() {
        return this.accessor.getStores();
    }

    public List<String> getNodeNames() {
        return this.accessor.getNCNames();
    }

    public String getCoredumpPath(String nodeId) {
        return this.accessor.getCoredumpPath(nodeId);
    }

    public Map<String, String> getCoredumpPaths() {
        return this.accessor.getCoredumpConfig();
    }

    public Map<String, ClusterPartition[]> getNodePartitions() {
        return this.accessor.getNodePartitions();
    }

    public SortedMap<Integer, ClusterPartition> getClusterPartitions() {
        return this.accessor.getClusterPartitions();
    }

    public Map<String, String> getTransactionLogDirs() {
        return this.accessor.getTransactionLogDirs();
    }

    public int getRegistrationTimeoutSecs() {
        return this.accessor.getInt(Option.METADATA_REGISTRATION_TIMEOUT_SECS);
    }

    public int getMetadataPort() {
        return this.accessor.getInt(Option.METADATA_LISTEN_PORT);
    }

    public int getMetadataCallbackPort() {
        return this.accessor.getInt(Option.METADATA_CALLBACK_PORT);
    }

    public static enum Option implements IOption
    {
        METADATA_NODE(OptionTypes.STRING, null),
        METADATA_REGISTRATION_TIMEOUT_SECS(OptionTypes.INTEGER, 60),
        METADATA_LISTEN_PORT(OptionTypes.INTEGER, 0),
        METADATA_CALLBACK_PORT(OptionTypes.INTEGER, 0);

        private final IOptionType type;
        private final Object defaultValue;

        private <T> Option(IOptionType<T> type, T defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            switch (this) {
                case METADATA_NODE: {
                    return "the node which should serve as the metadata node";
                }
                case METADATA_REGISTRATION_TIMEOUT_SECS: {
                    return "how long in seconds to wait for the metadata node to register with the CC";
                }
                case METADATA_LISTEN_PORT: {
                    return "IP port to bind metadata listener (0 = random port)";
                }
                case METADATA_CALLBACK_PORT: {
                    return "IP port to bind metadata callback listener (0 = random port)";
                }
            }
            throw new IllegalStateException("NYI: " + (Object)((Object)this));
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public Object get(IApplicationConfig cfg) {
            if (this == METADATA_NODE) {
                Object value = cfg.getStatic((IOption)this);
                return value != null ? value : (cfg.getNCNames().isEmpty() ? null : cfg.getNCNames().get(0));
            }
            return cfg.getStatic((IOption)this);
        }
    }
}

