/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.operators.std.FlushDatasetOperatorDescriptor;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.EmptyTupleSourceRuntimeFactory;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;

public class FlushDatasetUtil {
    private FlushDatasetUtil() {
    }

    public static void flushDataset(IHyracksClientConnection hcc, MetadataProvider metadataProvider, String dataverseName, String datasetName) throws Exception {
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        FlushDatasetUtil.flushDataset(hcc, metadataProvider, dataset);
    }

    public static void flushDataset(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Dataset dataset) throws Exception {
        CompilerProperties compilerProperties = metadataProvider.getApplicationContext().getCompilerProperties();
        int frameSize = compilerProperties.getFrameSize();
        JobSpecification spec = new JobSpecification(frameSize);
        RecordDescriptor[] rDescs = new RecordDescriptor[]{new RecordDescriptor(new ISerializerDeserializer[0])};
        AlgebricksMetaOperatorDescriptor emptySource = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 0, 1, new IPushRuntimeFactory[]{new EmptyTupleSourceRuntimeFactory()}, rDescs);
        TxnId txnId = metadataProvider.getTxnIdFactory().create();
        FlushDatasetOperatorDescriptor flushOperator = new FlushDatasetOperatorDescriptor((IOperatorDescriptorRegistry)spec, txnId, dataset.getDatasetId());
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)emptySource, 0, (IOperatorDescriptor)flushOperator, 0);
        Pair primarySplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset, dataset.getDatasetName());
        AlgebricksPartitionConstraint primaryPartitionConstraint = (AlgebricksPartitionConstraint)primarySplitsAndConstraint.second;
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)emptySource, (AlgebricksPartitionConstraint)primaryPartitionConstraint);
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(txnId, true);
        spec.setJobletEventListenerFactory((IJobletEventListenerFactory)jobEventListenerFactory);
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
    }
}

