/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.translator;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.external.library.java.base.ByteArrayAccessibleInputStream;
import org.apache.asterix.external.parser.JSONDataParser;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.ResultProperties;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;

public class RequestParameters
implements IRequestParameters {
    private final IResultSet resultSet;
    private final ResultProperties resultProperties;
    private final IStatementExecutor.Stats stats;
    private final Map<String, String> optionalParameters;
    private final IStatementExecutor.ResultMetadata outMetadata;
    private final String clientContextId;
    private final Map<String, IAObject> statementParameters;
    private final boolean multiStatement;

    public RequestParameters(IResultSet resultSet, ResultProperties resultProperties, IStatementExecutor.Stats stats, IStatementExecutor.ResultMetadata outMetadata, String clientContextId, Map<String, String> optionalParameters, Map<String, IAObject> statementParameters, boolean multiStatement) {
        this.resultSet = resultSet;
        this.resultProperties = resultProperties;
        this.stats = stats;
        this.outMetadata = outMetadata;
        this.clientContextId = clientContextId;
        this.optionalParameters = optionalParameters;
        this.statementParameters = statementParameters;
        this.multiStatement = multiStatement;
    }

    public IResultSet getResultSet() {
        return this.resultSet;
    }

    public ResultProperties getResultProperties() {
        return this.resultProperties;
    }

    public IStatementExecutor.Stats getStats() {
        return this.stats;
    }

    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }

    public IStatementExecutor.ResultMetadata getOutMetadata() {
        return this.outMetadata;
    }

    public String getClientContextId() {
        return this.clientContextId;
    }

    public boolean isMultiStatement() {
        return this.multiStatement;
    }

    public Map<String, IAObject> getStatementParameters() {
        return this.statementParameters;
    }

    public static Map<String, byte[]> serializeParameterValues(Map<String, JsonNode> inParams) throws HyracksDataException {
        if (inParams == null || inParams.isEmpty()) {
            return null;
        }
        JSONDataParser parser = new JSONDataParser(null, null);
        ByteArrayAccessibleOutputStream buffer = new ByteArrayAccessibleOutputStream();
        DataOutputStream bufferDataOutput = new DataOutputStream((OutputStream)buffer);
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        for (Map.Entry<String, JsonNode> me : inParams.entrySet()) {
            String name = me.getKey();
            JsonNode jsonValue = me.getValue();
            parser.setInputNode(jsonValue);
            buffer.reset();
            parser.parseAnyValue((DataOutput)bufferDataOutput);
            byte[] byteValue = buffer.toByteArray();
            m.put(name, byteValue);
        }
        return m;
    }

    public static Map<String, IAObject> deserializeParameterValues(Map<String, byte[]> inParams) throws HyracksDataException {
        if (inParams == null || inParams.isEmpty()) {
            return null;
        }
        HashMap<String, IAObject> m = new HashMap<String, IAObject>();
        ByteArrayAccessibleInputStream buffer = new ByteArrayAccessibleInputStream(new byte[0], 0, 0);
        DataInputStream bufferDataInput = new DataInputStream((InputStream)buffer);
        ISerializerDeserializer serDe = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANY);
        for (Map.Entry<String, byte[]> me : inParams.entrySet()) {
            String name = me.getKey();
            byte[] value = me.getValue();
            buffer.setContent(value, 0, value.length);
            IAObject iaValue = (IAObject)serDe.deserialize((DataInput)bufferDataInput);
            m.put(name, iaValue);
        }
        return m;
    }
}

