/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.resource;

import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;

public class OperatorResourcesComputer {
    public static final int MIN_OPERATOR_CORES = 1;
    private static final long MAX_BUFFER_PER_CONNECTION = 1L;
    private final int numComputationPartitions;
    private final long groupByMemorySize;
    private final long joinMemorySize;
    private final long sortMemorySize;
    private final long textSearchMemorySize;
    private final long frameSize;

    public OperatorResourcesComputer(int numComputationPartitions, int sortFrameLimit, int groupFrameLimit, int joinFrameLimit, int textSearchFrameLimit, long frameSize) {
        this.numComputationPartitions = numComputationPartitions;
        this.groupByMemorySize = (long)groupFrameLimit * frameSize;
        this.joinMemorySize = (long)joinFrameLimit * frameSize;
        this.sortMemorySize = (long)sortFrameLimit * frameSize;
        this.textSearchMemorySize = (long)textSearchFrameLimit * frameSize;
        this.frameSize = frameSize;
    }

    public int getOperatorRequiredCores(ILogicalOperator operator) {
        if (operator.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED || operator.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            return this.numComputationPartitions;
        }
        return 1;
    }

    public long getOperatorRequiredMemory(ILogicalOperator operator) {
        switch (operator.getOperatorTag()) {
            case AGGREGATE: 
            case ASSIGN: 
            case DATASOURCESCAN: 
            case DISTINCT: 
            case DISTRIBUTE_RESULT: 
            case EMPTYTUPLESOURCE: 
            case DELEGATE_OPERATOR: 
            case EXTERNAL_LOOKUP: 
            case LIMIT: 
            case MATERIALIZE: 
            case NESTEDTUPLESOURCE: 
            case PROJECT: 
            case REPLICATE: 
            case RUNNINGAGGREGATE: 
            case SCRIPT: 
            case SELECT: 
            case SINK: 
            case SPLIT: 
            case SUBPLAN: 
            case TOKENIZE: 
            case UNIONALL: 
            case UNNEST: 
            case LEFT_OUTER_UNNEST: 
            case UPDATE: 
            case WRITE: 
            case WRITE_RESULT: 
            case INDEX_INSERT_DELETE_UPSERT: 
            case INSERT_DELETE_UPSERT: 
            case INTERSECT: {
                return this.getOperatorRequiredMemory(operator, this.frameSize);
            }
            case LEFT_OUTER_UNNEST_MAP: 
            case UNNEST_MAP: {
                long unnestMapMemorySize = this.frameSize;
                if (this.isInvertedIndexSearch((AbstractUnnestMapOperator)operator)) {
                    unnestMapMemorySize += this.textSearchMemorySize;
                }
                return this.getOperatorRequiredMemory(operator, unnestMapMemorySize);
            }
            case EXCHANGE: {
                return this.getExchangeRequiredMemory((ExchangeOperator)operator);
            }
            case GROUP: {
                return this.getOperatorRequiredMemory(operator, this.groupByMemorySize);
            }
            case ORDER: {
                return this.getOperatorRequiredMemory(operator, this.sortMemorySize);
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                return this.getOperatorRequiredMemory(operator, this.joinMemorySize);
            }
        }
        throw new IllegalStateException("Unrecognized operator: " + operator.getOperatorTag());
    }

    private long getOperatorRequiredMemory(ILogicalOperator op, long memorySize) {
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED || op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            return memorySize * (long)this.numComputationPartitions;
        }
        return memorySize;
    }

    private boolean isInvertedIndexSearch(AbstractUnnestMapOperator op) {
        IPhysicalOperator physicalOperator = op.getPhysicalOperator();
        PhysicalOperatorTag physicalOperatorTag = physicalOperator.getOperatorTag();
        return physicalOperatorTag == PhysicalOperatorTag.LENGTH_PARTITIONED_INVERTED_INDEX_SEARCH || physicalOperatorTag == PhysicalOperatorTag.SINGLE_PARTITION_INVERTED_INDEX_SEARCH;
    }

    private long getExchangeRequiredMemory(ExchangeOperator op) {
        IPhysicalOperator physicalOperator = op.getPhysicalOperator();
        PhysicalOperatorTag physicalOperatorTag = physicalOperator.getOperatorTag();
        if (physicalOperatorTag == PhysicalOperatorTag.ONE_TO_ONE_EXCHANGE || physicalOperatorTag == PhysicalOperatorTag.SORT_MERGE_EXCHANGE) {
            return this.getOperatorRequiredMemory((ILogicalOperator)op, this.frameSize);
        }
        return 2L * (long)this.numComputationPartitions * (long)this.numComputationPartitions * this.frameSize;
    }
}

